/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.updatesys.transport.exchange;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.appwork.exceptions.WTFException;
import org.appwork.utils.IO;
import org.appwork.utils.Regex;
import org.appwork.utils.crypto.AWSign;
import org.appwork.utils.crypto.SignatureViolationException;
import org.appwork.utils.encoding.Base64;
import org.appwork.utils.formatter.HexFormatter;

@Deprecated
public class JarSignature {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private final File file;
    private final int revision;
    private final String path;
    private boolean compatibilityModeV1 = false;

    public File getFile() {
        return this.file;
    }

    public String getPath() {
        return this.path;
    }

    public int getRevision() {
        return this.revision;
    }

    public JarSignature(File f, int revision, String rel) {
        this.file = f;
        this.revision = revision;
        if (rel.endsWith("/")) {
            rel = rel.substring(0, rel.length() - 1);
        }
        this.path = rel;
    }

    public byte[] create(PrivateKey privateKey) throws SignatureViolationException {
        if (this.isCompatibilityModeV1()) {
            return this.createV1(privateKey);
        }
        return this.createV2(privateKey);
    }

    public byte[] createV1(PrivateKey privateKey) throws SignatureViolationException {
        String toSign = "J\r\n" + this.getRevision() + "\r\n" + this.getPath();
        try {
            Signature sig = Signature.getInstance("Sha256WithRSA");
            sig.initSign(privateKey);
            byte[] saltBytes = AWSign.get16ByteSalt(true);
            sig.update(saltBytes);
            this.fillSig(sig, toSign);
            byte[] ret = sig.sign();
            byte[] signature = new byte[ret.length + saltBytes.length];
            System.arraycopy(saltBytes, 0, signature, 0, saltBytes.length);
            System.arraycopy(ret, 0, signature, saltBytes.length, ret.length);
            StringBuilder sb = new StringBuilder();
            sb.append("J\r\n");
            sb.append(this.getRevision());
            sb.append("\r\n");
            sb.append(Base64.encodeToString(signature, false));
            return sb.toString().getBytes(UTF8);
        }
        catch (Exception e) {
            throw new SignatureViolationException(e);
        }
    }

    public byte[] createV2(PrivateKey privateKey) throws SignatureViolationException {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("J\r\n");
            sb.append(this.getRevision());
            sb.append("\r\n");
            String toSign = "J\r\n" + this.getRevision() + "\r\n" + this.getPath() + "\r\n" + HexFormatter.byteArrayToHex(this.getContentSHA256());
            byte[] v2Signature = AWSign.createSign(toSign.getBytes(UTF8), privateKey, true);
            sb.append(Base64.encodeToString(v2Signature, false));
            sb.append("\r\n");
            sb.append("V2");
            return sb.toString().getBytes(UTF8);
        }
        catch (Exception e) {
            throw new SignatureViolationException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fillSig(Signature sig, String toSign) throws IOException, UnsupportedEncodingException, SignatureException, NoSuchAlgorithmException, InvalidKeyException {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(this.getFile());
            ArrayList<ZipEntry> list = new ArrayList<ZipEntry>();
            Enumeration<? extends ZipEntry> enume = zipFile.entries();
            while (enume.hasMoreElements()) {
                ZipEntry jarEntry1 = enume.nextElement();
                list.add(jarEntry1);
            }
            Collections.sort(list, new Comparator<ZipEntry>(){

                @Override
                public int compare(ZipEntry arg0, ZipEntry arg1) {
                    return arg0.getName().compareTo(arg1.getName());
                }
            });
            InputStream input = null;
            sig.update(toSign.getBytes(UTF8));
            byte[] buffer = new byte[Short.MAX_VALUE];
            for (ZipEntry e : list) {
                if (e.isDirectory()) {
                    sig.update("D,".getBytes(UTF8));
                    sig.update(e.getName().getBytes(UTF8));
                    continue;
                }
                sig.update("J,".getBytes(UTF8));
                sig.update(e.getName().getBytes(UTF8));
                input = zipFile.getInputStream(e);
                try {
                    int len;
                    while ((len = input.read(buffer)) != -1) {
                        if (len <= 0) continue;
                        sig.update(buffer, 0, len);
                    }
                }
                finally {
                    try {
                        input.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        finally {
            if (zipFile != null) {
                zipFile.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getContentSHA256() throws IOException {
        File file = this.getFile();
        if (!file.isFile()) {
            throw new WTFException("ContentSHA256 of directory!?");
        }
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(file);
            ArrayList<ZipEntry> list = new ArrayList<ZipEntry>();
            Enumeration<? extends ZipEntry> enume = zipFile.entries();
            while (enume.hasMoreElements()) {
                ZipEntry jarEntry1 = enume.nextElement();
                list.add(jarEntry1);
            }
            Collections.sort(list, new Comparator<ZipEntry>(){

                @Override
                public int compare(ZipEntry arg0, ZipEntry arg1) {
                    return arg0.getName().compareTo(arg1.getName());
                }
            });
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            byte[] buffer = new byte[Short.MAX_VALUE];
            InputStream is = null;
            for (ZipEntry e : list) {
                if (e.isDirectory()) {
                    md.update("D,".getBytes(UTF8));
                    md.update(e.getName().getBytes(UTF8));
                    continue;
                }
                md.update("J,".getBytes(UTF8));
                md.update(e.getName().getBytes(UTF8));
                is = zipFile.getInputStream(e);
                try {
                    int len;
                    while ((len = is.read(buffer)) != -1) {
                        if (len <= 0) continue;
                        md.update(buffer, 0, len);
                    }
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (Exception exception) {}
                }
            }
            Object object = md.digest();
            return object;
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e);
        }
        finally {
            if (zipFile != null) {
                zipFile.close();
            }
        }
    }

    public boolean isCompatibilityModeV1() {
        return this.compatibilityModeV1;
    }

    public String readSignatureString() throws IOException {
        return IO.readFileToTrimmedString(new File(this.getFile().getAbsolutePath() + ".jarSignature"));
    }

    public void setCompatibilityModeV1(boolean compatibilityModeV1) {
        this.compatibilityModeV1 = compatibilityModeV1;
    }

    public void verify(PublicKey key) throws SignatureViolationException {
        try {
            Object[] lines = Regex.getLines(this.readSignatureString());
            int signatureRevision = Integer.parseInt(lines[1]);
            byte[] signature = Base64.decode(lines[2]);
            if (signatureRevision != -1 && signatureRevision != this.getRevision()) {
                throw new SignatureViolationException(Arrays.toString(lines) + " does not match " + this.getFile() + " (Revision Mismatch " + this.getRevision() + "!=" + signatureRevision + ")");
            }
            if (lines.length >= 4 && "V2".equals(lines[3])) {
                String toSign = "J\r\n" + this.getRevision() + "\r\n" + this.getPath() + "\r\n" + HexFormatter.byteArrayToHex(this.getContentSHA256());
                AWSign.verify(toSign.getBytes(UTF8), key, signature, true);
            } else {
                String toSign = "J\r\n" + signatureRevision + "\r\n" + this.getPath();
                Signature sig = Signature.getInstance("Sha256WithRSA");
                sig.initVerify(key);
                byte[] salt = new byte[signature.length - 256];
                System.arraycopy(signature, 0, salt, 0, salt.length);
                byte[] actualSignature = new byte[256];
                System.arraycopy(signature, signature.length - 256, actualSignature, 0, actualSignature.length);
                signature = actualSignature;
                sig.update(salt);
                this.fillSig(sig, toSign);
                if (!sig.verify(signature)) {
                    throw new SignatureViolationException("Sig Check Failed");
                }
            }
        }
        catch (SignatureViolationException e) {
            if (e.getCause() == null) {
                throw new SignatureViolationException("Path:" + this.getPath() + "|" + e.getMessage());
            }
            throw new SignatureViolationException("Path:" + this.getPath(), e.getCause());
        }
        catch (Exception e) {
            throw new SignatureViolationException("Path:" + this.getPath(), e.getCause());
        }
    }

    public static enum JARDIFFSUPPORT {
        NONE,
        DEPRECATED,
        V2;

    }
}

