/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.updatesys.transport.exchange;

import java.util.HashSet;
import java.util.Locale;
import org.appwork.storage.BuildsInfo;
import org.appwork.storage.Storable;
import org.appwork.storage.StorableAvailableSince;
import org.appwork.storage.StorableDoc;
import org.appwork.storage.StorableExample;
import org.appwork.storage.TypeRef;
import org.appwork.storage.flexijson.FlexiUtils;
import org.appwork.storage.flexijson.mapper.FlexiMapperException;
import org.appwork.updatesys.transport.exchange.BooleanTristate;
import org.appwork.utils.StringUtils;

@StorableDoc(value="*.serveroptions files can be generated in the AdminTool. \r\n\"ServerOptions documentation\":https://projects.appwork.org/projects/connect-system-documentation/wiki/ServerOptions\r\nThese files are used to distribute files only if the requesting client matches the filter.")
public class ServerOptions
implements Storable {
    public static final TypeRef<ServerOptions> TYPE = new TypeRef<ServerOptions>(ServerOptions.class){};
    private BuildsInfo targetBuilds;
    @StorableDoc(value="If set, the path is distributed if the client's system architecture matches.\r\nOptions:  NA, X86, ARM, PPC,SPARC, IA64, RISCV")
    @StorableExample(value="\"X86\"")
    protected String arch = null;
    @StorableDoc(value="Default by inheritance: \"TRUE\": If set to \"FALSE\", BSD systems won't get the path")
    protected BooleanTristate bsd = BooleanTristate.NOTSET;
    @StorableDoc(value="--reserved--")
    protected BooleanTristate dedupe = BooleanTristate.NOTSET;
    @StorableDoc(value="Default by inheritance: \"TRUE\": If set to \"FALSE\", Connect Clients running on a 32 Bit JVM won't get the path")
    protected BooleanTristate jvm32Bit = BooleanTristate.NOTSET;
    @StorableDoc(value="Default by inheritance: \"TRUE\": If set to \"FALSE\", Connect Clients running on a 64 Bit JVM won't get the path")
    protected BooleanTristate jvm64Bit = BooleanTristate.NOTSET;
    @StorableDoc(value="Default by inheritance: \"TRUE\": If set to \"FALSE\", LINUX systems won't get the path")
    protected BooleanTristate linux = BooleanTristate.NOTSET;
    @StorableDoc(value="Default by inheritance: \"TRUE\": If set to \"FALSE\", MAC systems won't get the path")
    protected BooleanTristate mac = BooleanTristate.NOTSET;
    @StorableDoc(value="Default by inheritance: \"TRUE\": If set to \"FALSE\", 32 Bit systems won't get the path")
    protected BooleanTristate os32Bit = BooleanTristate.NOTSET;
    @StorableDoc(value="Default by inheritance: \"TRUE\": If set to \"FALSE\", 64 Bit systems won't get the path")
    protected BooleanTristate os64Bit = BooleanTristate.NOTSET;
    @StorableDoc(value="This path will only be distributed to clients that request at least one of the ids listed in this field. \r\nEvery client always requests these \"Auto-IDs\":https://projects.appwork.org/projects/connect-system-documentation/wiki/Optional_extensions : \r\n-> Group-ID (Can be used to distribute the path only to certain staging groups - example: distribute only if the client is in group beta):<namespace>/group.<groupid|ALL>, \r\n-> Sibling-ID(can be used to distribute the path only of the client has <target-repo-namespace> installed - example: distribute only if repo 'B' is installed.): <target-repo-namespace> ")
    protected HashSet<String> parentIDList = null;
    @StorableAvailableSince(value="2021-12-10T00:00+0200")
    @StorableDoc(value="If set to \"TRUE\", the server won't execute any type of special handling on the file - no ZIP/JAR validation or anything like this. \r\nSet this flag to \"TRUE\" if the file extension does not reflect the actual file content. To date(08.06.2022) setting the flag to \"TRUE\" means: No JAR-DIFF, No JAR-validation.")
    protected BooleanTristate raw = BooleanTristate.NOTSET;
    @StorableDoc(value="Default by inheritance: \"TRUE\": If set to \"FALSE\", WINDOWS systems won't get the path")
    protected BooleanTristate windows = BooleanTristate.NOTSET;
    @StorableAvailableSince(value="2023-08-25T00:00+0200")
    protected BooleanTristate zipDelta = BooleanTristate.NOTSET;

    public static void main(String[] args) throws FlexiMapperException {
        ServerOptions co = new ServerOptions();
        System.out.println(FlexiUtils.serializeConfigStorable(co));
    }

    @StorableAvailableSince(value="2023-07-17T00:00+0200")
    @StorableDoc(value="Information about the target Clients/Server this configuration should be used with. ")
    public BuildsInfo getTargetBuilds() {
        return this.targetBuilds;
    }

    public void setTargetBuilds(BuildsInfo clientInfo) {
        this.targetBuilds = clientInfo;
    }

    public static ServerOptions merge(ServerOptions child, ServerOptions parent) {
        if (child == null) {
            return parent;
        }
        if (parent == null) {
            return child;
        }
        ServerOptions ret = parent.clone();
        ret._set(child, true);
        return ret;
    }

    public ServerOptions clone() {
        ServerOptions ret = new ServerOptions();
        ret._set(this);
        return ret;
    }

    public String getArch() {
        return this.arch;
    }

    public BooleanTristate getBsd() {
        return this.bsd;
    }

    public BooleanTristate getDedupe() {
        return this.dedupe;
    }

    public BooleanTristate getJvm32Bit() {
        return this.jvm32Bit;
    }

    public BooleanTristate getJvm64Bit() {
        return this.jvm64Bit;
    }

    public BooleanTristate getLinux() {
        return this.linux;
    }

    public BooleanTristate getMac() {
        return this.mac;
    }

    public BooleanTristate getOs32Bit() {
        return this.os32Bit;
    }

    public BooleanTristate getOs64Bit() {
        return this.os64Bit;
    }

    public HashSet<String> getParentIDList() {
        return this.parentIDList;
    }

    public BooleanTristate getRaw() {
        return this.raw;
    }

    public BooleanTristate getWindows() {
        return this.windows;
    }

    public BooleanTristate getZipDelta() {
        return this.zipDelta;
    }

    public void _set(ServerOptions source) {
        this._set(source, false);
    }

    public void _set(ServerOptions source, boolean setOnlyIfSet) {
        if (source != null) {
            boolean forceSet = !setOnlyIfSet;
            BooleanTristate is32BitJvm = BooleanTristate.valueOf(source.getJvm32Bit());
            if (forceSet || BooleanTristate.NOTSET != is32BitJvm) {
                this.setJvm32Bit(is32BitJvm);
            }
            BooleanTristate is64BitJvm = BooleanTristate.valueOf(source.getJvm64Bit());
            if (forceSet || BooleanTristate.NOTSET != is64BitJvm) {
                this.setJvm64Bit(is64BitJvm);
            }
            BooleanTristate isLinux = BooleanTristate.valueOf(source.getLinux());
            if (forceSet || BooleanTristate.NOTSET != isLinux) {
                this.setLinux(isLinux);
            }
            BooleanTristate isMac = BooleanTristate.valueOf(source.getMac());
            if (forceSet || BooleanTristate.NOTSET != isMac) {
                this.setMac(isMac);
            }
            BooleanTristate isWindows = BooleanTristate.valueOf(source.getWindows());
            if (forceSet || BooleanTristate.NOTSET != isWindows) {
                this.setWindows(isWindows);
            }
            BooleanTristate isBsd = BooleanTristate.valueOf(source.getBsd());
            if (forceSet || BooleanTristate.NOTSET != isBsd) {
                this.setBsd(isBsd);
            }
            BooleanTristate is32BitOS = BooleanTristate.valueOf(source.getOs32Bit());
            if (forceSet || BooleanTristate.NOTSET != is32BitOS) {
                this.setOs32Bit(is32BitOS);
            }
            BooleanTristate is64BitOS = BooleanTristate.valueOf(source.getOs64Bit());
            if (forceSet || BooleanTristate.NOTSET != is64BitOS) {
                this.setOs64Bit(is64BitOS);
            }
            BooleanTristate dedupe = BooleanTristate.valueOf(source.getDedupe());
            if (forceSet || BooleanTristate.NOTSET != dedupe) {
                this.setDedupe(dedupe);
            }
            BooleanTristate raw = BooleanTristate.valueOf(source.getRaw());
            if (forceSet || BooleanTristate.NOTSET != raw) {
                this.setRaw(raw);
            }
            BooleanTristate zipDelta = BooleanTristate.valueOf(source.getZipDelta());
            if (forceSet || BooleanTristate.NOTSET != zipDelta) {
                this.setZipDelta(zipDelta);
            }
            String arch = source.getArch();
            if (forceSet || StringUtils.isNotEmpty(arch)) {
                this.setArch(arch);
            }
            HashSet<String> parentIDs = source.getParentIDList();
            if (forceSet || parentIDs != null) {
                HashSet<String> list = this.getParentIDList();
                if (list == null) {
                    this.setParentIDList(parentIDs);
                } else if (parentIDs != null) {
                    for (String id : parentIDs) {
                        if (id == null) continue;
                        list.add(id.toLowerCase(Locale.ENGLISH));
                    }
                }
            }
        }
    }

    public void setArch(String arch) {
        this.arch = StringUtils.isEmpty(arch) ? null : arch;
    }

    public void setBsd(BooleanTristate bsd) {
        this.bsd = BooleanTristate.valueOf(bsd);
    }

    public void setDedupe(BooleanTristate dedupe) {
        this.dedupe = BooleanTristate.valueOf(dedupe);
    }

    public void setJvm32Bit(BooleanTristate jvm32Bit) {
        this.jvm32Bit = BooleanTristate.valueOf(jvm32Bit);
    }

    public void setJvm64Bit(BooleanTristate jvm64Bit) {
        this.jvm64Bit = BooleanTristate.valueOf(jvm64Bit);
    }

    public void setLinux(BooleanTristate linux) {
        this.linux = BooleanTristate.valueOf(linux);
    }

    public void setMac(BooleanTristate mac) {
        this.mac = BooleanTristate.valueOf(mac);
    }

    public void setOs32Bit(BooleanTristate os32Bit) {
        this.os32Bit = BooleanTristate.valueOf(os32Bit);
    }

    public void setOs64Bit(BooleanTristate os64Bit) {
        this.os64Bit = BooleanTristate.valueOf(os64Bit);
    }

    public void setParentIDList(HashSet<String> parentIDList) {
        if (parentIDList == null || parentIDList.size() == 0) {
            this.parentIDList = null;
        } else {
            HashSet<String> ret = new HashSet<String>();
            for (String id : parentIDList) {
                if (id == null) continue;
                ret.add(id.toLowerCase(Locale.ENGLISH));
            }
            this.parentIDList = ret;
        }
    }

    public void setRaw(BooleanTristate raw) {
        this.raw = BooleanTristate.valueOf(raw);
    }

    public void setZipDelta(BooleanTristate zipDelta) {
        this.zipDelta = BooleanTristate.valueOf(zipDelta);
    }

    public void setWindows(BooleanTristate windows) {
        this.windows = BooleanTristate.valueOf(windows);
    }

    public void write(ServerOptions source) {
        this._set(source, true);
    }
}

