/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.updatesys.transport.exchange;

import org.appwork.storage.Storable;
import org.appwork.updatesys.transport.exchange.DeduplicationMode;
import org.appwork.updatesys.transport.exchange.JarSignature;

public class UpdatePackageBillingDetails
implements Storable {
    private long addedModifiedFiles = 0L;
    private long addedModifiedFilesSize = 0L;
    private long addedNewFiles = 0L;
    private long addedNewFilesSize = 0L;
    private String appID = null;
    private long buildTime = 0L;
    private long calcTime = 0L;
    private long clientOptions = 0L;
    private long clientOptionsSize = 0L;
    private long completeTime = 0L;
    private int compressionLevel = 0;
    private long contentSize = 0L;
    private long dedupInterFiles = 0L;
    private long dedupInterFilesSaved = 0L;
    private long rawFilesSize = 0L;
    private long rawFiles = 0L;
    private String sha256 = null;
    private long dedupIntraFiles = 0L;
    private long dedupIntraFilesSaved = 0L;
    private long deltaModifiedFiles = 0L;
    private long deltaModifiedFilesSaved = 0L;
    private long deltaModifiedFilesSize = 0L;
    private long deltaUnchangedFiles = 0L;
    private long deltaUnchangedFilesSize = 0L;
    private long directories = 0L;
    private long fileSize = 0L;
    private boolean full = false;
    private JarSignature.JARDIFFSUPPORT jarDiffSupport = null;
    private long jarSignatures = 0L;
    private long jarSignaturesSize = 0L;
    private String prefix = null;
    private long removedSignatures = 0L;
    private long removedSignaturesSize = 0L;
    private long requestTime = 0L;
    private int revision = 0;
    private long updateSignatures = 0L;
    private long updateSignaturesSize = 0L;
    private DeduplicationMode deduplicationMode = DeduplicationMode.NONE;
    private boolean encrypted = false;
    private String causePackageSettingsID = null;
    private int causeSourceRevision = -1;

    public String getSha256() {
        return this.sha256;
    }

    public void setSha256(String sha256) {
        this.sha256 = sha256;
    }

    public long getRawFiles() {
        return this.rawFiles;
    }

    public void setRawFiles(long rawFiles) {
        this.rawFiles = rawFiles;
    }

    public long getRawFilesSize() {
        return this.rawFilesSize;
    }

    public void addRawFile(long fileSize) {
        ++this.rawFiles;
        this.rawFilesSize += fileSize;
    }

    public void setRawFilesSize(long rawFilesSize) {
        this.rawFilesSize = rawFilesSize;
    }

    public long getDedupInterFilesSaved() {
        return this.dedupInterFilesSaved;
    }

    public void setDedupInterFilesSaved(long dedupInterFilesSaved) {
        this.dedupInterFilesSaved = dedupInterFilesSaved;
    }

    public long getDedupIntraFilesSaved() {
        return this.dedupIntraFilesSaved;
    }

    public void setDedupIntraFilesSaved(long dedupIntraFilesSaved) {
        this.dedupIntraFilesSaved = dedupIntraFilesSaved;
    }

    public JarSignature.JARDIFFSUPPORT getJarDiffSupport() {
        JarSignature.JARDIFFSUPPORT ret = this.jarDiffSupport;
        return ret != null ? this.jarDiffSupport : JarSignature.JARDIFFSUPPORT.NONE;
    }

    public void setJarDiffSupport(JarSignature.JARDIFFSUPPORT jarDiffSupport) {
        this.jarDiffSupport = jarDiffSupport == null ? JarSignature.JARDIFFSUPPORT.NONE : jarDiffSupport;
    }

    public boolean isEncrypted() {
        return this.encrypted;
    }

    public void setEncrypted(boolean encrypted) {
        this.encrypted = encrypted;
    }

    public DeduplicationMode getDeduplicationMode() {
        return this.deduplicationMode;
    }

    public void setDeduplicationMode(DeduplicationMode deduplicationMode) {
        this.deduplicationMode = deduplicationMode;
    }

    public UpdatePackageBillingDetails() {
    }

    public UpdatePackageBillingDetails(String appID, int revision) {
        this.appID = appID;
        this.revision = revision;
    }

    public void addClientOption(long fileSize) {
        ++this.clientOptions;
        this.clientOptionsSize += fileSize;
    }

    public void addDeltaFile(long fileSizeBefore, long fileSizeAfter) {
        ++this.deltaModifiedFiles;
        this.deltaModifiedFilesSize += fileSizeBefore;
        this.deltaModifiedFilesSaved += fileSizeBefore - fileSizeAfter;
    }

    public void addDirectory() {
        ++this.directories;
    }

    public void addJarSignture(long fileSize) {
        ++this.jarSignatures;
        this.jarSignaturesSize += fileSize;
    }

    public void addDedup(DeduplicationMode mode, long fileSizeBefore, long fileSizeAfter) {
        switch (mode) {
            case INTER: {
                this.addDedupInter(fileSizeBefore, fileSizeAfter);
                return;
            }
            case INTRA: {
                this.addDedupIntra(fileSizeBefore, fileSizeAfter);
                return;
            }
        }
    }

    public void addDedupInter(long fileSizeBefore, long fileSizeAfter) {
        ++this.dedupInterFiles;
        this.dedupInterFilesSaved += fileSizeBefore - fileSizeAfter;
    }

    public void addDedupIntra(long fileSizeBefore, long fileSizeAfter) {
        ++this.dedupIntraFiles;
        this.dedupIntraFilesSaved += fileSizeBefore - fileSizeAfter;
    }

    public void addModifiedFile(long fileSize) {
        ++this.addedModifiedFiles;
        this.addedModifiedFilesSize += fileSize;
    }

    public void addNewFile(long fileSize) {
        ++this.addedNewFiles;
        this.addedNewFilesSize += fileSize;
    }

    public void addRemovedSignature(long fileSize) {
        ++this.removedSignatures;
        this.removedSignaturesSize += fileSize;
    }

    public void addUnchangedFile(long fileSize) {
        ++this.deltaUnchangedFiles;
        this.deltaUnchangedFilesSize += fileSize;
    }

    public void addUpdateSignature(long fileSize) {
        ++this.updateSignatures;
        this.updateSignaturesSize += fileSize;
    }

    public long getAddedModifiedFiles() {
        return this.addedModifiedFiles;
    }

    public long getAddedModifiedFilesSize() {
        return this.addedModifiedFilesSize;
    }

    public long getAddedNewFiles() {
        return this.addedNewFiles;
    }

    public long getAddedNewFilesSize() {
        return this.addedNewFilesSize;
    }

    public String getAppID() {
        return this.appID;
    }

    public long getBuildTime() {
        return this.buildTime;
    }

    public long getCalcTime() {
        return this.calcTime;
    }

    public long getClientOptions() {
        return this.clientOptions;
    }

    public long getClientOptionsSize() {
        return this.clientOptionsSize;
    }

    public long getCompleteTime() {
        return this.completeTime;
    }

    public int getCompressionLevel() {
        return this.compressionLevel;
    }

    public long getContentSize() {
        return this.contentSize;
    }

    public long getDedupInterFiles() {
        return this.dedupInterFiles;
    }

    public long getDedupIntraFiles() {
        return this.dedupIntraFiles;
    }

    public long getDeltaModifiedFiles() {
        return this.deltaModifiedFiles;
    }

    public long getDeltaModifiedFilesSaved() {
        return this.deltaModifiedFilesSaved;
    }

    public long getDeltaModifiedFilesSize() {
        return this.deltaModifiedFilesSize;
    }

    public long getDeltaUnchangedFiles() {
        return this.deltaUnchangedFiles;
    }

    public long getDeltaUnchangedFilesSize() {
        return this.deltaUnchangedFilesSize;
    }

    public long getDirectories() {
        return this.directories;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public long getJarSignatures() {
        return this.jarSignatures;
    }

    public long getJarSignaturesSize() {
        return this.jarSignaturesSize;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public long getRemovedSignatures() {
        return this.removedSignatures;
    }

    public long getRemovedSignaturesSize() {
        return this.removedSignaturesSize;
    }

    public long getRequestTime() {
        return this.requestTime;
    }

    public int getRevision() {
        return this.revision;
    }

    public long getUpdateSignatures() {
        return this.updateSignatures;
    }

    public long getUpdateSignaturesSize() {
        return this.updateSignaturesSize;
    }

    public boolean isFull() {
        return this.full;
    }

    public boolean isJarDiffSupported() {
        return !JarSignature.JARDIFFSUPPORT.NONE.equals((Object)this.getJarDiffSupport());
    }

    public void setAddedModifiedFiles(long addedModifiedFiles) {
        this.addedModifiedFiles = addedModifiedFiles;
    }

    public void setAddedModifiedFilesSize(long addedModifiedFilesSize) {
        this.addedModifiedFilesSize = addedModifiedFilesSize;
    }

    public void setAddedNewFiles(long addedNewFiles) {
        this.addedNewFiles = addedNewFiles;
    }

    public void setAddedNewFilesSize(long addedNewFilesSize) {
        this.addedNewFilesSize = addedNewFilesSize;
    }

    public void setAppID(String appID) {
        this.appID = appID;
    }

    public void setBuildTime(long buildTime) {
        this.buildTime = buildTime;
    }

    public void setCalcTime(long calcTime) {
        this.calcTime = calcTime;
    }

    public void setClientOptions(long clientOptions) {
        this.clientOptions = clientOptions;
    }

    public void setClientOptionsSize(long clientOptionsSize) {
        this.clientOptionsSize = clientOptionsSize;
    }

    public void setCompleteTime(long completeTime) {
        this.completeTime = completeTime;
    }

    public void setCompressionLevel(int compressionLevel) {
        this.compressionLevel = compressionLevel;
    }

    public void setContentSize(long contentSize) {
        this.contentSize = contentSize;
    }

    public void setDedupInterFiles(long dedupInterFiles) {
        this.dedupInterFiles = dedupInterFiles;
    }

    public void setDedupIntraFiles(long dedupIntraFiles) {
        this.dedupIntraFiles = dedupIntraFiles;
    }

    public void setDeltaModifiedFiles(long deltaModifiedFiles) {
        this.deltaModifiedFiles = deltaModifiedFiles;
    }

    public void setDeltaModifiedFilesSaved(long deltaModifiedFilesSaved) {
        this.deltaModifiedFilesSaved = deltaModifiedFilesSaved;
    }

    public void setDeltaModifiedFilesSize(long deltaModifiedFilesSize) {
        this.deltaModifiedFilesSize = deltaModifiedFilesSize;
    }

    public void setDeltaUnchangedFiles(long deltaUnchangedFiles) {
        this.deltaUnchangedFiles = deltaUnchangedFiles;
    }

    public void setDeltaUnchangedFilesSize(long deltaUnchangedFilesSize) {
        this.deltaUnchangedFilesSize = deltaUnchangedFilesSize;
    }

    public void setDirectories(long directories) {
        this.directories = directories;
    }

    public void setFileSize(long fileSize) {
        this.fileSize = fileSize;
    }

    public void setFull(boolean isFull) {
        this.full = isFull;
    }

    public void setJarDiffSupported(boolean value) {
        if (this.jarDiffSupport == null) {
            this.jarDiffSupport = value ? JarSignature.JARDIFFSUPPORT.DEPRECATED : JarSignature.JARDIFFSUPPORT.NONE;
        }
    }

    public void setJarSignatures(long jarSignatures) {
        this.jarSignatures = jarSignatures;
    }

    public void setJarSignaturesSize(long jarSignaturesSize) {
        this.jarSignaturesSize = jarSignaturesSize;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setRemovedSignatures(long removedSignatures) {
        this.removedSignatures = removedSignatures;
    }

    public void setRemovedSignaturesSize(long removedSignaturesSize) {
        this.removedSignaturesSize = removedSignaturesSize;
    }

    public void setRequestTime(long requestTime) {
        this.requestTime = requestTime;
    }

    public void setRevision(int revision) {
        this.revision = revision;
    }

    public void setUpdateSignatures(long updateSignatures) {
        this.updateSignatures = updateSignatures;
    }

    public void setUpdateSignaturesSize(long updateSignaturesSize) {
        this.updateSignaturesSize = updateSignaturesSize;
    }

    public void setCausePackageSettingsID(String packageSettingsID) {
        this.causePackageSettingsID = packageSettingsID;
    }

    public String getCausePackageSettingsID() {
        return this.causePackageSettingsID;
    }

    public void setCauseRevision(int sourceRevision) {
        this.causeSourceRevision = sourceRevision;
    }

    public int getCauseRevision() {
        return this.causeSourceRevision;
    }
}

