/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipInputStream;
import org.appwork.exceptions.WTFException;
import org.appwork.storage.simplejson.mapper.ClassCache;
import org.appwork.storage.simplejson.mapper.Getter;
import org.appwork.utils.DebugMode;
import org.appwork.utils.Exceptions;
import org.appwork.utils.Files;
import org.appwork.utils.GetterSetter;
import org.appwork.utils.JVMVersion;
import org.appwork.utils.StringUtils;
import org.appwork.utils.reflection.Clazz;
import org.appwork.utils.reflection.CompiledType;

public class ReflectionUtils {
    private static final HashMap<Class<?>, Collection<GetterSetter>> GETTER_SETTER_CACHE = new HashMap();

    public static void walkThroughObject(Object obj, WalkThroughObjectCallBack callback) {
        ReflectionUtils.walkThroughObject(obj, obj == null ? Void.TYPE : obj.getClass(), "", callback);
    }

    public static void walkThroughObject(Object obj, Type type, String path, WalkThroughObjectCallBack callback) {
        block23: {
            if (path == null) {
                path = "";
            }
            if (type == null) {
                type = obj != null ? obj.getClass() : Object.class;
            }
            callback.onObject(path, type, obj);
            if (StringUtils.isNotEmpty(path)) {
                path = path + ".";
            }
            if (obj == null) break block23;
            if (ReflectionUtils.isListOrArray(obj)) {
                int l1 = ReflectionUtils.getListLength(obj);
                Class<?> actualTypes = null;
                if (obj instanceof List) {
                    if (type instanceof ParameterizedType) {
                        actualTypes = ((ParameterizedType)((Object)type)).getActualTypeArguments()[0];
                    }
                } else if (type instanceof Class && type.isArray()) {
                    actualTypes = type.getComponentType();
                } else {
                    throw new WTFException("Not Supported");
                }
                for (int i = 0; i < l1; ++i) {
                    ReflectionUtils.walkThroughObject(ReflectionUtils.getListElement(obj, i), actualTypes, path + i, callback);
                }
            } else if (obj instanceof Map) {
                Type actualTypes = null;
                if (type instanceof ParameterizedType) {
                    actualTypes = ((ParameterizedType)((Object)type)).getActualTypeArguments()[1];
                }
                for (Map.Entry es : ((Map)obj).entrySet()) {
                    ReflectionUtils.walkThroughObject(es.getValue(), actualTypes, path + es.getKey(), callback);
                }
            } else {
                if (Clazz.isPrimitive(obj.getClass()) || Clazz.isEnum(obj.getClass()) || Clazz.isString(obj.getClass())) {
                    return;
                }
                try {
                    ClassCache cc = ClassCache.getClassCache(obj.getClass());
                    for (Getter c : cc.getGetter()) {
                        ReflectionUtils.walkThroughObject(c.getValue(obj), c.getMethod().getGenericReturnType(), path + c.getKey(), callback);
                    }
                }
                catch (SecurityException e) {
                    throw new WTFException(e);
                }
                catch (NoSuchMethodException e) {
                    throw new WTFException(e);
                }
                catch (IllegalArgumentException e) {
                    throw new WTFException(e);
                }
                catch (IllegalAccessException e) {
                    throw new WTFException(e);
                }
                catch (InvocationTargetException e) {
                    throw new WTFException(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<Class<? extends T>> getClassesInPackage(ClassLoader cl, String name, final Pattern pattern, Class<T> class1) {
        ArrayList<Class<T>> ret = new ArrayList<Class<T>>();
        try {
            String finalName = name.replace(".", "/");
            Enumeration<URL> found = cl.getResources(finalName);
            while (found.hasMoreElements()) {
                Object path;
                URL url = found.nextElement();
                if (url.getProtocol().equalsIgnoreCase("jar")) {
                    path = url.getPath();
                    File jarFile = new File(new URL(((String)path).substring(0, ((String)path).lastIndexOf(33))).toURI());
                    ZipInputStream jis = null;
                    try {
                        JarEntry e;
                        jis = new JarInputStream(new FileInputStream(jarFile));
                        while ((e = ((JarInputStream)jis).getNextJarEntry()) != null) {
                            Matcher matcher;
                            if (!e.getName().endsWith(".class") || !e.getName().startsWith(finalName) || pattern != null && !(matcher = pattern.matcher(e.getName())).matches()) continue;
                            String classPath = e.getName().replace("/", ".");
                            classPath = classPath.substring(0, classPath.length() - 6);
                            try {
                                Class<?> clazz = cl.loadClass(classPath);
                                if (class1 == clazz || class1 != null && !class1.isAssignableFrom(clazz)) continue;
                                ret.add(clazz);
                            }
                            catch (Throwable clazz) {}
                        }
                        continue;
                    }
                    finally {
                        try {
                            jis.close();
                        }
                        catch (Throwable e) {}
                        continue;
                    }
                }
                path = new File(url.toURI());
                int i = ((File)path).getAbsolutePath().replace("\\", "/").indexOf(finalName);
                final File root = new File(((File)path).getAbsolutePath().substring(0, i));
                List<File> files = Files.getFiles(new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        Matcher matcher;
                        if (!pathname.getName().endsWith(".class")) {
                            return false;
                        }
                        String rel = Files.getRelativePath(root, pathname);
                        return pattern == null || (matcher = pattern.matcher(rel)).matches();
                    }
                }, new File(url.toURI()));
                for (File classFile : files) {
                    String classPath = Files.getRelativePath(root, classFile).replace("/", ".").replace("\\", ".");
                    classPath = classPath.substring(0, classPath.length() - 6);
                    try {
                        Class<?> clazz = cl.loadClass(classPath);
                        if (class1 == clazz || class1 != null && !class1.isAssignableFrom(clazz)) continue;
                        ret.add(clazz);
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<GetterSetter> getGettersSetteres(Class<?> clazz) {
        Collection<GetterSetter> ret = GETTER_SETTER_CACHE.get(clazz);
        if (ret != null) {
            return ret;
        }
        Class<?> org = clazz;
        HashMap<Class<?>, Collection<GetterSetter>> hashMap = GETTER_SETTER_CACHE;
        synchronized (hashMap) {
            ret = GETTER_SETTER_CACHE.get(clazz);
            if (ret != null) {
                return ret;
            }
            HashMap<String, GetterSetter> map = new HashMap<String, GetterSetter>();
            while (clazz != null) {
                for (Method m : clazz.getDeclaredMethods()) {
                    String key = null;
                    boolean getter = false;
                    if (m.getName().startsWith("is") && Clazz.isBoolean(m.getReturnType()) && m.getParameterTypes().length == 0) {
                        key = m.getName().substring(2);
                        getter = true;
                    } else if (m.getName().startsWith("get") && m.getParameterTypes().length == 0) {
                        key = m.getName().substring(3);
                        getter = true;
                    } else if (m.getName().startsWith("set") && m.getParameterTypes().length == 1) {
                        key = m.getName().substring(3);
                        getter = false;
                    }
                    if (!StringUtils.isNotEmpty(key)) continue;
                    String unmodifiedKey = key;
                    GetterSetter v = (GetterSetter)map.get(key = ClassCache.createKey(key));
                    if (v == null) {
                        v = new GetterSetter(key);
                        map.put(key, v);
                    }
                    if (getter) {
                        v.setGetter(m);
                    } else {
                        v.setSetter(m);
                    }
                    try {
                        Field field = clazz.getField(unmodifiedKey.substring(0, 1).toLowerCase(Locale.ENGLISH) + unmodifiedKey.substring(1));
                        v.setField(field);
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        // empty catch block
                    }
                }
                clazz = clazz.getSuperclass();
            }
            GETTER_SETTER_CACHE.put(org, map.values());
            return GETTER_SETTER_CACHE.get(org);
        }
    }

    public static Object[] getEnumValues(Class<? extends Enum> type) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        while (type.isAnonymousClass()) {
            type = type.getSuperclass();
        }
        return type.getEnumConstants();
    }

    public static Object getEnumValueOf(Class<? extends Enum> type, String value) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        while (type.isAnonymousClass()) {
            type = type.getSuperclass();
        }
        return Enum.valueOf(type, value);
    }

    public static <T> T getFieldValue(String className, String fieldName, Object instance, Class<T> returnType) throws ClassNotFoundException, InvocationTargetException, NoSuchFieldException {
        Class<?> clazz = Class.forName(className);
        return ReflectionUtils.getFieldValue(clazz, fieldName, instance, returnType);
    }

    public static <T> T getFieldValue(Class<?> clazz, String fieldName, Object instance, Class<T> returnType) throws InvocationTargetException, NoSuchFieldException {
        Field field;
        try {
            field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
        }
        catch (SecurityException e) {
            throw ReflectionUtils.initCause(new NoSuchFieldException("Class:" + clazz + "|Field:" + fieldName + "|Type:" + returnType), e);
        }
        catch (RuntimeException e) {
            throw ReflectionUtils.initCause(new NoSuchFieldException("Class:" + clazz + "|Field:" + fieldName + "|Type:" + returnType), e);
        }
        try {
            Object returnValue = field.get(instance);
            if (returnValue == null) {
                return null;
            }
            if (!returnType.isInstance(returnValue)) {
                return (T)returnValue;
            }
            return returnType.cast(returnValue);
        }
        catch (IllegalAccessException e) {
            throw new InvocationTargetException(e);
        }
        catch (IllegalArgumentException e) {
            throw new InvocationTargetException(e);
        }
        catch (ClassCastException e) {
            throw new InvocationTargetException(e);
        }
    }

    private static <E extends Throwable> E initCause(E throwing, Throwable cause) {
        try {
            throwing.initCause(cause);
            return throwing;
        }
        catch (Throwable ex) {
            return Exceptions.addSuppressed(throwing, cause);
        }
    }

    public static Field getField(String className, String fieldName, Object instance, Class<?> type) throws ClassNotFoundException, NoSuchFieldException {
        Class<?> clazz = Class.forName(className);
        return ReflectionUtils.getField(clazz, fieldName, instance, type);
    }

    public static Field getField(Class<?> clazz, String fieldName, Object instance, Class<?> type) throws NoSuchFieldException {
        try {
            Field field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            if (type == null || type.isAssignableFrom(field.getType())) {
                return field;
            }
            return null;
        }
        catch (SecurityException e) {
            throw ReflectionUtils.initCause(new NoSuchFieldException("Class:" + clazz + "|Field:" + fieldName + "|Type:" + type), e);
        }
        catch (RuntimeException e) {
            throw ReflectionUtils.initCause(new NoSuchFieldException("Class:" + clazz + "|Field:" + fieldName + "|Type:" + type), e);
        }
    }

    public static <T> T invoke(String className, String methodName, Object instance, Class<T> returnType, Class<?>[] paramTypes, Object ... params) throws InvocationTargetException {
        return ReflectionUtils.invoke(className, null, methodName, instance, returnType, paramTypes, params);
    }

    public static <T> T invoke(String className, String methodName, Object instance, Class<T> returnType, Object ... params) throws InvocationTargetException {
        return ReflectionUtils.invoke(className, null, methodName, instance, returnType, null, params);
    }

    public static <T> T invoke(Class<?> clazz, String methodName, Object instance, Class<T> returnType, Object ... params) throws InvocationTargetException {
        return ReflectionUtils.invoke(clazz, null, methodName, instance, returnType, null, params);
    }

    public static <T> T invoke(String className, InvokeMethodLookup<T> methodLookup, String methodName, Object instance, Class<T> returnType, Class<?>[] paramTypes, Object ... params) throws InvocationTargetException {
        Class<?> clazz;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new InvocationTargetException(e);
        }
        return ReflectionUtils.invoke(clazz, methodLookup, methodName, instance, returnType, paramTypes, params);
    }

    public static <T> T invoke(Class<?> clazz, InvokeMethodLookup<T> methodLookup, String methodName, Object instance, Class<T> returnType, Class<?>[] paramTypes, Object ... params) throws InvocationTargetException {
        Method method;
        try {
            method = ReflectionUtils.findMatchingMethod(clazz, methodLookup, methodName, instance, returnType, paramTypes, params);
        }
        catch (NoSuchMethodException e) {
            throw new InvocationTargetException(e);
        }
        try {
            Object returnValue = method.invoke(instance, params);
            if (returnValue == null) {
                return null;
            }
            if (!returnType.isInstance(returnValue)) {
                return (T)returnValue;
            }
            return returnType.cast(returnValue);
        }
        catch (IllegalAccessException e) {
            throw new InvocationTargetException(e);
        }
        catch (IllegalArgumentException e) {
            throw new InvocationTargetException(e);
        }
        catch (ClassCastException e) {
            throw new InvocationTargetException(e);
        }
    }

    public static <T> Method findMatchingMethod(Class<?> clazz, InvokeMethodLookup<T> methodLookup, String methodName, Object instance, Class<T> returnType, Class<?>[] paramTypes, Object ... params) throws NoSuchMethodException {
        Method method = null;
        NoSuchMethodException firstNoSuchMethodException = null;
        while (true) {
            try {
                method = paramTypes != null && paramTypes.length > 0 ? clazz.getDeclaredMethod(methodName, paramTypes) : ReflectionUtils.findMatchinMethodInternal(clazz, methodName, params);
                try {
                    method.setAccessible(true);
                }
                catch (RuntimeException e) {
                    throw Exceptions.addSuppressed(new NoSuchMethodException("Class:" + clazz + "|MethodName:" + methodName + "|Type:" + returnType), e);
                }
            }
            catch (NoSuchMethodException e) {
                Class<?> next;
                if (firstNoSuchMethodException == null) {
                    firstNoSuchMethodException = e;
                }
                if ((next = clazz.getSuperclass()) == null || methodLookup != null && !methodLookup.lookup(next, methodName, instance, returnType, params)) {
                    throw firstNoSuchMethodException;
                }
                clazz = next;
                continue;
            }
            break;
        }
        return method;
    }

    public static Method findMatchingMethod(String className, String methodName, Object[] params) throws ClassNotFoundException, NoSuchMethodException {
        Class<?> clazz = Class.forName(className);
        return ReflectionUtils.findMatchingMethod(clazz, methodName, params);
    }

    public static Method findMatchingMethod(Class<?> clazz, String methodName, Object[] params) throws NoSuchMethodException {
        return ReflectionUtils.findMatchingMethod(clazz, null, methodName, null, null, null, params);
    }

    private static Method findMatchinMethodInternal(Class<?> clazz, String methodName, Object[] params) throws NoSuchMethodException {
        ArrayList<Method> methods = new ArrayList<Method>();
        block0: for (Method m : clazz.getDeclaredMethods()) {
            Class<?>[] methodParameterTypes = null;
            if (!(JVMVersion.isMinimum(JVMVersion.JAVA_1_8) ? params.length == m.getParameterCount() : (methodParameterTypes = m.getParameterTypes()).length == params.length) || !m.getName().equals(methodName)) continue;
            if (methodParameterTypes == null) {
                methodParameterTypes = m.getParameterTypes();
            }
            for (int i = 0; i < methodParameterTypes.length; ++i) {
                Object param = params[i];
                Class<?> expected = methodParameterTypes[i];
                if (!Clazz.objectIsTypeOf(param, expected)) continue block0;
            }
            methods.add(m);
        }
        if (methods.size() == 0) {
            throw new NoSuchMethodException("Could not find a matching method:'" + methodName + "|parameters:" + Arrays.asList(params) + "|class:" + clazz);
        }
        if (methods.size() > 1) {
            throw new NoSuchMethodException("Ambigious method definitions: " + methods + "|class:" + clazz);
        }
        return (Method)methods.get(0);
    }

    public static boolean isInstanceOf(String className, Class<?> clazz) {
        for (Class<?> walk = clazz; walk != null; walk = walk.getSuperclass()) {
            if (walk.getName().equals(className)) {
                return true;
            }
            Class<?>[] interfaces = walk.getInterfaces();
            if (interfaces.length <= 0) continue;
            for (Class<?> intf : interfaces) {
                if (!ReflectionUtils.isInstanceOf(className, intf)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isInstanceOf(String className, Object instance) {
        Class<?> clazz = instance.getClass();
        return ReflectionUtils.isInstanceOf(className, clazz);
    }

    public static Number castNumber(Number value, Class<?> clazz) {
        if (Clazz.isByte(clazz)) {
            return value.byteValue();
        }
        if (Clazz.isShort(clazz)) {
            return value.shortValue();
        }
        if (Clazz.isInteger(clazz)) {
            return value.intValue();
        }
        if (Clazz.isLong(clazz)) {
            return value.longValue();
        }
        if (Clazz.isDouble(clazz)) {
            return value.doubleValue();
        }
        if (Clazz.isFloat(clazz)) {
            return Float.valueOf(value.floatValue());
        }
        if (Number.class.equals(clazz)) {
            return value;
        }
        throw new WTFException("Unsupported type: " + clazz);
    }

    public static <T> Collection<T> wrapCollection(Object object, boolean unmodifiableCollection, Class<T> elementType) {
        Class<?> raw;
        Class<?> clazz = raw = object != null ? ReflectionUtils.getRaw(object.getClass()) : null;
        if (raw == null) {
            return null;
        }
        if (Collection.class.isAssignableFrom(raw)) {
            Collection ret = (Collection)object;
            if (unmodifiableCollection) {
                return Collections.unmodifiableCollection(ret);
            }
            return ret;
        }
        return ReflectionUtils.wrapList(object, unmodifiableCollection, elementType);
    }

    public static <T> Collection<T> wrapUnmodifiableCollection(Object object, Class<T> elementType) {
        return ReflectionUtils.wrapCollection(object, true, elementType);
    }

    public static <T> List<T> wrapList(final Object object, boolean unmodifiableList, Class<T> elementType) {
        List ret;
        Class<?> raw;
        Class<?> clazz = raw = object != null ? ReflectionUtils.getRaw(object.getClass()) : null;
        if (raw == null) {
            return null;
        }
        if (List.class.isAssignableFrom(raw)) {
            ret = (List)object;
        } else {
            if (Collection.class.isAssignableFrom(raw)) {
                return ReflectionUtils.wrapList(((Collection)object).toArray(new Object[0]), true, elementType);
            }
            if (raw.isArray()) {
                ret = new AbstractList<T>(){

                    @Override
                    public T get(int index) {
                        return Array.get(object, index);
                    }

                    @Override
                    public T set(int index, T element) {
                        Object ret = Array.get(object, index);
                        Array.set(object, index, element);
                        return ret;
                    }

                    @Override
                    public int size() {
                        return Array.getLength(object);
                    }
                };
            } else {
                return null;
            }
        }
        if (unmodifiableList) {
            return Collections.unmodifiableList(ret);
        }
        return ret;
    }

    public static <T> List<T> wrapUnmodifiableList(Object object, Class<T> elementType) {
        return ReflectionUtils.wrapList(object, true, elementType);
    }

    public static final Object getListElement(Object object, int i) {
        if (object.getClass().isArray()) {
            return Array.get(object, i);
        }
        if (object instanceof List) {
            return ((List)object).get(i);
        }
        throw new IllegalStateException(object + " is no List");
    }

    public static final int getListLength(Object object) {
        if (object.getClass().isArray()) {
            return Array.getLength(object);
        }
        if (object instanceof List) {
            return ((List)object).size();
        }
        throw new IllegalStateException(object + " is no List");
    }

    public static final boolean isListOrArray(Type t) {
        Class<?> raw;
        return t != null && (raw = ReflectionUtils.getRaw(t)) != null && (raw.isArray() || List.class.isAssignableFrom(raw));
    }

    public static final boolean isList(Object object) {
        return ReflectionUtils.isListOrArray(object);
    }

    public static final boolean isListOrArray(Object object) {
        return object != null && ReflectionUtils.isListOrArray(object.getClass());
    }

    public static void setField(Object o, String fieldname, Object value) throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException {
        Field f = ReflectionUtils.getField(o.getClass(), fieldname);
        f.setAccessible(true);
        f.set(o, value);
    }

    private static Field getField(Class<? extends Object> clazz, String fieldname) throws NoSuchFieldException {
        NoSuchFieldException first = null;
        for (Class<? extends Object> nextClazz = clazz; nextClazz != null; nextClazz = nextClazz.getSuperclass()) {
            try {
                Field field = nextClazz.getDeclaredField(fieldname);
                return field;
            }
            catch (NoSuchFieldException e) {
                if (first != null) continue;
                first = e;
                continue;
            }
        }
        if (first != null) {
            throw first;
        }
        throw new NoSuchFieldException(clazz + "|" + fieldname);
    }

    public static <TT> TT getAnnotation(Type t, Class<TT> class1) {
        Class<?> raw = ReflectionUtils.getRaw(t);
        if (raw == null) {
            return null;
        }
        return raw.getAnnotation(class1);
    }

    public static Class<?> getRaw(Type t) {
        if (t instanceof Class) {
            return (Class)t;
        }
        if (t instanceof ParameterizedType) {
            Type raw = ((ParameterizedType)t).getRawType();
            if (raw instanceof Class) {
                return (Class)raw;
            }
        } else {
            if (t instanceof TypeVariable) {
                return null;
            }
            if (t instanceof WildcardType) {
                return null;
            }
            if (t instanceof GenericArrayType) {
                return null;
            }
            if (t instanceof CompiledType) {
                return ((CompiledType)((Object)t)).raw;
            }
        }
        DebugMode.logInIDEOnly(new WTFException("Unsupported? " + t.getClass() + " - " + t));
        return null;
    }

    public static Type getComponentClass(Type cls) throws IllegalArgumentException {
        if (cls instanceof Class) {
            return ((Class)cls).getComponentType();
        }
        if (cls instanceof ParameterizedType) {
            if (List.class.isAssignableFrom(ReflectionUtils.getRaw(cls))) {
                if (((ParameterizedType)cls).getActualTypeArguments().length != 1) {
                    throw new IllegalArgumentException("Method requires a list argument with a single generic declaration");
                }
                return ((ParameterizedType)cls).getActualTypeArguments()[0];
            }
            if (Set.class.isAssignableFrom(ReflectionUtils.getRaw(cls))) {
                if (((ParameterizedType)cls).getActualTypeArguments().length != 1) {
                    throw new IllegalArgumentException("Method requires a list argument with a single generic declaration");
                }
                return ((ParameterizedType)cls).getActualTypeArguments()[0];
            }
            if (Map.class.isAssignableFrom(ReflectionUtils.getRaw(cls))) {
                if (((ParameterizedType)cls).getActualTypeArguments().length != 2) {
                    throw new IllegalArgumentException("Method requires a map argument with 2 generic declarations");
                }
                return ((ParameterizedType)cls).getActualTypeArguments()[1];
            }
        } else if (cls instanceof GenericArrayType) {
            return ((GenericArrayType)cls).getGenericComponentType();
        }
        throw new IllegalArgumentException("Class or ParameterizedType are supported. You tried: " + cls);
    }

    public static boolean isTypeOf(Type cls, Class<?> class1) {
        if (cls == class1 && cls != null) {
            return true;
        }
        Class<?> raw = ReflectionUtils.getRaw(cls);
        return raw != null && class1 != null && class1.isAssignableFrom(raw);
    }

    public static boolean hasDecimalPlaces(Number number) {
        if (Clazz.isFloatingPointNumber(number.getClass())) {
            if (number instanceof BigDecimal) {
                try {
                    ((BigDecimal)number).longValueExact();
                    return false;
                }
                catch (ArithmeticException e) {
                    return true;
                }
            }
            boolean ret = number instanceof Float ? Float.compare((float)number.longValue() * 1.0f, number.floatValue()) != 0 : Double.compare((double)number.longValue() * 1.0, number.doubleValue()) != 0;
            return ret;
        }
        return false;
    }

    public static Long getLongValue(Number number) {
        if (number == null || ReflectionUtils.hasDecimalPlaces(number)) {
            return null;
        }
        if (number instanceof BigDecimal) {
            try {
                return ((BigDecimal)number).longValueExact();
            }
            catch (ArithmeticException e) {
                return null;
            }
        }
        if (number instanceof BigInteger) {
            try {
                if (JVMVersion.isMinimum(JVMVersion.JAVA_1_8)) {
                    return ((BigInteger)number).longValueExact();
                }
                return new BigDecimal((BigInteger)number).longValueExact();
            }
            catch (ArithmeticException e) {
                return null;
            }
        }
        return number.longValue();
    }

    public static boolean isCharRange(Number number) {
        Long longValue = ReflectionUtils.getLongValue(number);
        return longValue != null && longValue <= 65535L && longValue >= 0L;
    }

    public static boolean isByteRange(Number number) {
        Long longValue = ReflectionUtils.getLongValue(number);
        return longValue != null && longValue <= 127L && longValue >= -128L;
    }

    public static boolean isShortRange(Number number) {
        Long longValue = ReflectionUtils.getLongValue(number);
        return longValue != null && longValue <= 32767L && longValue >= -32768L;
    }

    public static boolean isIntRange(Number number) {
        Long longValue = ReflectionUtils.getLongValue(number);
        return longValue != null && longValue <= Integer.MAX_VALUE && longValue >= Integer.MIN_VALUE;
    }

    public static boolean isLongRange(Number number) {
        Long longValue = ReflectionUtils.getLongValue(number);
        return longValue != null && longValue <= Long.MAX_VALUE && longValue >= Long.MIN_VALUE;
    }

    public static Float getFloatValue(Number number) {
        if (number == null) {
            return null;
        }
        if (number instanceof BigDecimal) {
            try {
                BigDecimal bg = (BigDecimal)number;
                Float floatValue = Float.valueOf(bg.floatValue());
                BigDecimal sub = bg.subtract(BigDecimal.valueOf(floatValue.floatValue()));
                if (sub.longValueExact() == 0L) {
                    return floatValue;
                }
                return null;
            }
            catch (ArithmeticException e) {
                return null;
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if (number instanceof BigInteger) {
            return ReflectionUtils.getFloatValue(new BigDecimal((BigInteger)number));
        }
        return Float.valueOf(number.floatValue());
    }

    public static Double getDoubleValue(Number number) {
        if (number == null) {
            return null;
        }
        if (number instanceof BigDecimal) {
            try {
                BigDecimal bg = (BigDecimal)number;
                Double doubleValue = bg.doubleValue();
                BigDecimal sub = bg.subtract(BigDecimal.valueOf(doubleValue));
                if (sub.longValueExact() == 0L) {
                    return doubleValue;
                }
                return null;
            }
            catch (ArithmeticException e) {
                return null;
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if (number instanceof BigInteger) {
            return ReflectionUtils.getDoubleValue(new BigDecimal((BigInteger)number));
        }
        return number.doubleValue();
    }

    public static boolean isFloatRange(Number number) {
        Float floatValue = ReflectionUtils.getFloatValue(number);
        return floatValue != null && (floatValue.floatValue() <= Float.MAX_VALUE && floatValue.floatValue() >= -3.4028235E38f || Float.isNaN(floatValue.floatValue()));
    }

    public static boolean isDoubleRange(Number number) {
        Double doubleValue = ReflectionUtils.getDoubleValue(number);
        return doubleValue != null && (doubleValue <= Double.MAX_VALUE && doubleValue >= -1.7976931348623157E308 || Double.isNaN(doubleValue));
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Object cast(Object value, Type destType) {
        block39: {
            block40: {
                if (value == null) {
                    if (Clazz.isNumberType(destType)) {
                        if (!((Class)destType).isPrimitive()) return null;
                        return ReflectionUtils.cast(0, destType);
                    }
                    if (!Clazz.isBoolean(destType)) return null;
                    if (!((Class)destType).isPrimitive()) return null;
                    return false;
                }
                if (Clazz.isString(destType)) {
                    if (value.getClass() != char[].class) return StringUtils.valueOfOrNull(value);
                    return new String((char[])value);
                }
                if (!(value instanceof CharSequence)) break block40;
                String stringValue = String.valueOf(value);
                if (Clazz.isNumberType(destType)) {
                    if (!Clazz.isFixedPointNumber(destType)) return ReflectionUtils.cast(Double.valueOf(stringValue), destType);
                    return ReflectionUtils.cast(Long.valueOf(stringValue), destType);
                }
                if (Clazz.isBoolean(destType)) {
                    if ("true".equals(stringValue)) {
                        return ReflectionUtils.cast(Boolean.TRUE, destType);
                    }
                    if ("false".equals(stringValue)) {
                        return ReflectionUtils.cast(Boolean.FALSE, destType);
                    }
                    break block39;
                } else if (Number.class.equals((Object)destType)) {
                    if (stringValue.matches("-?\\d+")) {
                        return Long.parseLong(stringValue);
                    }
                    if (stringValue.matches("-?\\d+\\.\\d+")) {
                        return Double.valueOf(stringValue).longValue();
                    }
                    break block39;
                } else {
                    if (Clazz.isCharacter(destType)) {
                        char[] chars = stringValue.toCharArray();
                        if (chars.length == 1) return Character.valueOf(chars[0]);
                        throw new ClassCastException(stringValue + " cannot be represented with single char");
                    }
                    if (destType != char[].class) return value;
                    return stringValue.toCharArray();
                }
            }
            if (value instanceof Number && Clazz.isBoolean(destType)) {
                int numValue = ((Number)value).intValue();
                if (numValue == 1) {
                    return ReflectionUtils.cast(Boolean.TRUE, destType);
                }
                if (numValue == 0) {
                    return ReflectionUtils.cast(Boolean.FALSE, destType);
                }
            } else if (value instanceof Character) {
                if (Clazz.isBoolean(destType)) {
                    char numValue = ((Character)value).charValue();
                    if (numValue == '1') {
                        return ReflectionUtils.cast(Boolean.TRUE, destType);
                    }
                    if (numValue == '0') {
                        return ReflectionUtils.cast(Boolean.FALSE, destType);
                    }
                } else {
                    if (Clazz.isCharacter(destType)) {
                        return value;
                    }
                    if (Clazz.isFixedPointNumber(destType)) {
                        return Character.codePointAt(new char[]{((Character)value).charValue()}, 0);
                    }
                }
            }
        }
        Object ret = value;
        if (destType instanceof Class && ((Class)destType).isPrimitive()) {
            if (destType == Boolean.TYPE) {
                return (boolean)((Boolean)value);
            }
            if (destType == Character.TYPE) {
                if (ReflectionUtils.isCharRange((Number)value)) return Character.valueOf((char)((Number)value).intValue());
                if (!ReflectionUtils.isDoubleRange((Number)value)) throw new ClassCastException(value + " is not in int Range " + '\u0000' + " to " + '\uffff');
                if ((double)((Number)value).intValue() != ((Number)value).doubleValue()) throw new ClassCastException(value + " is not in int Range " + '\u0000' + " to " + '\uffff');
                if (ReflectionUtils.isCharRange(((Number)value).intValue())) return Character.valueOf((char)((Number)value).intValue());
                throw new ClassCastException(value + " is not in int Range " + '\u0000' + " to " + '\uffff');
            }
            if (destType == Byte.TYPE) {
                if (ReflectionUtils.isByteRange((Number)value)) return ((Number)value).byteValue();
                if (!ReflectionUtils.isDoubleRange((Number)value)) throw new ClassCastException(value + " is not in int Range " + -128 + " to " + 127);
                if ((double)((Number)value).intValue() != ((Number)value).doubleValue()) throw new ClassCastException(value + " is not in int Range " + -128 + " to " + 127);
                if (ReflectionUtils.isByteRange(((Number)value).intValue())) return ((Number)value).byteValue();
                throw new ClassCastException(value + " is not in int Range " + -128 + " to " + 127);
            }
            if (destType == Short.TYPE) {
                if (ReflectionUtils.isShortRange((Number)value)) return ((Number)value).shortValue();
                if (!ReflectionUtils.isDoubleRange((Number)value)) throw new ClassCastException(value + " is not in int Range " + Short.MIN_VALUE + " to " + Short.MAX_VALUE);
                if ((double)((Number)value).intValue() != ((Number)value).doubleValue()) throw new ClassCastException(value + " is not in int Range " + Short.MIN_VALUE + " to " + Short.MAX_VALUE);
                if (ReflectionUtils.isShortRange(((Number)value).intValue())) return ((Number)value).shortValue();
                throw new ClassCastException(value + " is not in int Range " + Short.MIN_VALUE + " to " + Short.MAX_VALUE);
            }
            if (destType == Integer.TYPE) {
                if (ReflectionUtils.isIntRange((Number)value)) return ((Number)value).intValue();
                if (!ReflectionUtils.isDoubleRange((Number)value)) throw new ClassCastException(value + " is not in int Range " + Integer.MIN_VALUE + " to " + Integer.MAX_VALUE);
                if ((double)((Number)value).intValue() == ((Number)value).doubleValue()) return ((Number)value).intValue();
                throw new ClassCastException(value + " is not in int Range " + Integer.MIN_VALUE + " to " + Integer.MAX_VALUE);
            }
            if (destType == Long.TYPE) {
                if (ReflectionUtils.isLongRange((Number)value)) return ((Number)value).longValue();
                throw new ClassCastException(value + " is not in long Range " + Long.MIN_VALUE + " to " + Long.MAX_VALUE);
            }
            if (destType == Float.TYPE) {
                if (ReflectionUtils.isFloatRange((Number)value)) return Float.valueOf(((Number)value).floatValue());
                throw new ClassCastException(value + " is not in float Range " + Float.MIN_VALUE + " to " + Float.MAX_VALUE);
            }
            if (destType != Double.TYPE) return ret;
            if (ReflectionUtils.isDoubleRange((Number)value)) return ((Number)value).doubleValue();
            throw new ClassCastException(value + " is not in double Range " + Double.MIN_VALUE + " to " + Double.MAX_VALUE);
        }
        if (destType == Boolean.class) {
            return (boolean)((Boolean)value);
        }
        if (destType == Character.class) {
            if (ReflectionUtils.isCharRange((Number)value)) return Character.valueOf((char)((Number)value).intValue());
            throw new ClassCastException(value + " is not in char Range " + '\u0000' + " to " + '\uffff');
        }
        if (destType == Byte.class) {
            if (ReflectionUtils.isByteRange((Number)value)) return ((Number)value).byteValue();
            throw new ClassCastException(value + " is not in byte Range " + -128 + " to " + 127);
        }
        if (destType == Short.class) {
            if (ReflectionUtils.isShortRange((Number)value)) return ((Number)value).shortValue();
            throw new ClassCastException(value + " is not in short Range " + Short.MIN_VALUE + " to " + Short.MAX_VALUE);
        }
        if (destType == Integer.class) {
            if (ReflectionUtils.isIntRange((Number)value)) return ((Number)value).intValue();
            throw new ClassCastException(value + " is not in int Range " + Integer.MIN_VALUE + " to " + Integer.MAX_VALUE);
        }
        if (destType == Long.class) {
            if (ReflectionUtils.isLongRange((Number)value)) return ((Number)value).longValue();
            throw new ClassCastException(value + " is not in long Range " + Long.MIN_VALUE + " to " + Long.MAX_VALUE);
        }
        if (destType == Float.class) {
            if (ReflectionUtils.isFloatRange((Number)value)) return Float.valueOf(((Number)value).floatValue());
            throw new ClassCastException(value + " is not in float Range " + Float.MIN_VALUE + " to " + Float.MAX_VALUE);
        }
        if (destType != Double.class) return ret;
        if (ReflectionUtils.isDoubleRange((Number)value)) return ((Number)value).doubleValue();
        throw new ClassCastException(value + " is not in double Range " + Double.MIN_VALUE + " to " + Double.MAX_VALUE);
    }

    public static boolean isEnum(Type last) {
        if (last instanceof Class) {
            return ((Class)last).isEnum();
        }
        return false;
    }

    public static Set<Type> listExceptions(Class<?> class1) {
        ClassCache cc;
        try {
            cc = ClassCache.getClassCache(class1);
        }
        catch (SecurityException e1) {
            throw new WTFException(e1);
        }
        catch (NoSuchMethodException e1) {
            throw new WTFException(e1);
        }
        HashSet<Type> ret = new HashSet<Type>();
        for (Type cl : cc.getTypeHierarchy()) {
            if (!(cl instanceof Class)) continue;
            for (Method m : ((Class)cl).getDeclaredMethods()) {
                for (Type e : m.getGenericExceptionTypes()) {
                    ret.add(e);
                }
            }
        }
        return ret;
    }

    public static interface InvokeMethodLookup<T> {
        public boolean lookup(Class<?> var1, String var2, Object var3, Class<T> var4, Object ... var5);
    }

    public static interface WalkThroughObjectCallBack {
        public void onObject(String var1, Type var2, Object var3);
    }
}

