/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils;

import java.util.concurrent.atomic.AtomicLong;

public class UniqueAlltimeID {
    private static final AtomicLong ID = new AtomicLong(System.currentTimeMillis());
    private long id;

    public UniqueAlltimeID() {
        this.id = UniqueAlltimeID.next();
    }

    private static long createUniqueAlltimeID() {
        long lastID;
        long id = -1L;
        do {
            lastID = ID.get();
            id = System.currentTimeMillis();
            if (id < lastID) {
                id = lastID + 1L;
                continue;
            }
            if (id != lastID) continue;
            ++id;
        } while (!ID.compareAndSet(lastID, id));
        return id;
    }

    public UniqueAlltimeID(long id2) {
        this.id = id2;
    }

    public int hashCode() {
        return (int)(this.id ^ this.id >>> 32);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o instanceof UniqueAlltimeID) {
            return ((UniqueAlltimeID)o).id == this.id;
        }
        return false;
    }

    public long getID() {
        return this.id;
    }

    public String toString() {
        return Long.toString(this.id);
    }

    public void setID(long ID2) {
        this.id = ID2;
    }

    public long refresh() {
        long next = UniqueAlltimeID.next();
        this.setID(next);
        return next;
    }

    public static String create() {
        return Long.toString(UniqueAlltimeID.next());
    }

    public static long next() {
        return UniqueAlltimeID.createUniqueAlltimeID();
    }
}

