/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.awfc;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;

public class AWFCUtils {
    private final byte[] buffer = new byte[16];
    private final OutputStream os;
    private final InputStream is;
    private static final Charset UTF8 = Charset.forName("UTF-8");

    public AWFCUtils() {
        this.is = null;
        this.os = null;
    }

    public AWFCUtils(InputStream is) {
        this.is = is;
        this.os = null;
    }

    public AWFCUtils(OutputStream os) {
        this.os = os;
        this.is = null;
    }

    public int ensureRead() throws IOException {
        int read = this.getCurrentInputStream().read();
        if (read == -1) {
            throw new EOFException();
        }
        return read;
    }

    public byte[] ensureRead(int size, byte[] buffer) throws IOException {
        int done;
        byte[] stringBytes = buffer;
        if (stringBytes == null) {
            stringBytes = new byte[size];
        }
        if (size > stringBytes.length) {
            throw new IOException("buffer too small");
        }
        int read = 0;
        for (done = 0; done < size && (read = this.getCurrentInputStream().read(stringBytes, done, size - done)) != -1; done += read) {
        }
        if (done != size) {
            throw new EOFException(done + "!=" + size);
        }
        return stringBytes;
    }

    public InputStream getCurrentInputStream() throws IOException {
        if (this.is != null) {
            return this.is;
        }
        throw new IOException("no InputStream available");
    }

    public OutputStream getCurrentOutputStream() throws IOException {
        if (this.os != null) {
            return this.os;
        }
        throw new IOException("no OutputStream available");
    }

    public boolean readBoolean() throws IOException {
        int read = this.ensureRead();
        if (read == 1) {
            return true;
        }
        if (read == 0) {
            return false;
        }
        throw new IOException("Invalid boolean value!");
    }

    public long readLong() throws IOException {
        this.ensureRead(8, this.buffer);
        return ((long)this.buffer[0] << 56) + ((long)(this.buffer[1] & 0xFF) << 48) + ((long)(this.buffer[2] & 0xFF) << 40) + ((long)(this.buffer[3] & 0xFF) << 32) + ((long)(this.buffer[4] & 0xFF) << 24) + (long)((this.buffer[5] & 0xFF) << 16) + (long)((this.buffer[6] & 0xFF) << 8) + (long)((this.buffer[7] & 0xFF) << 0);
    }

    public int readShort() throws IOException {
        this.ensureRead(2, this.buffer);
        return ((this.buffer[0] & 0xFF) << 8) + ((this.buffer[1] & 0xFF) << 0);
    }

    public String readString() throws IOException {
        return this.readString(this.readShort());
    }

    public String readString(int size) throws IOException {
        return new String(this.ensureRead(size, null), 0, size, UTF8);
    }

    public String readString(byte[] tempBuffer) throws IOException {
        int size = this.readShort();
        return new String(this.ensureRead(size, tempBuffer), 0, size, UTF8);
    }

    public void writeBoolean(boolean b) throws IOException {
        this.getCurrentOutputStream().write(b ? 1 : 0);
    }

    public void writeLong(long l) throws IOException {
        this.buffer[0] = (byte)(l >>> 56);
        this.buffer[1] = (byte)(l >>> 48);
        this.buffer[2] = (byte)(l >>> 40);
        this.buffer[3] = (byte)(l >>> 32);
        this.buffer[4] = (byte)(l >>> 24);
        this.buffer[5] = (byte)(l >>> 16);
        this.buffer[6] = (byte)(l >>> 8);
        this.buffer[7] = (byte)(l >>> 0);
        this.getCurrentOutputStream().write(this.buffer, 0, 8);
    }

    public long readLongOptimized() throws IOException {
        long ret = 0L;
        long read = 0L;
        int position = 0;
        while (true) {
            read = this.ensureRead();
            ret += read >>> 1 << position * 7;
            if ((read & 1L) == 0L) {
                return ret;
            }
            ++position;
        }
    }

    public void writeLongOptimized(long value) throws IOException {
        if (value < 0L) {
            throw new NumberFormatException("value must be >=0");
        }
        long rest = value;
        int bufferPosition = 0;
        while (true) {
            int write = (int)((rest & 0x7FL) << 1 & 0xFFL);
            this.buffer[bufferPosition] = (byte)write;
            if ((rest >>>= 7) == 0L) {
                this.getCurrentOutputStream().write(this.buffer, 0, bufferPosition + 1);
                return;
            }
            this.buffer[bufferPosition] = (byte)(this.buffer[bufferPosition] | 1);
            ++bufferPosition;
        }
    }

    public void writeShort(int v) throws IOException {
        this.buffer[0] = (byte)(v >>> 8 & 0xFF);
        this.buffer[1] = (byte)(v >>> 0 & 0xFF);
        this.getCurrentOutputStream().write(this.buffer, 0, 2);
    }

    public void writeString(String string) throws IOException {
        if (string == null) {
            throw new IOException("string == null");
        }
        byte[] stringBytes = string.getBytes(UTF8);
        if (stringBytes.length > Short.MAX_VALUE) {
            throw new IllegalArgumentException("StringSize must not be greater than 32767 bytes");
        }
        this.writeShort(stringBytes.length);
        this.getCurrentOutputStream().write(stringBytes);
    }
}

