/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.encoding;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;

public class URLEncode {
    public static final String RFC2396_RFC_UNRESERVEDCHARACTERS = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ-_.!~*'()";
    public static final String RFC2396_JAVA_UNRESERVEDCHARACTERS = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ-_.*";
    public static final String RFC3986_RFC_UNRESERVEDCHARACTERS = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ-._~";

    public static String encodeRFC2396(String input) {
        return URLEncode.encodeRFC2396((CharSequence)input);
    }

    public static String encodeRFC2396(CharSequence input) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char ch = input.charAt(i);
            if (ch == ' ') {
                sb.append("+");
                continue;
            }
            if (RFC2396_JAVA_UNRESERVEDCHARACTERS.indexOf(ch) != -1) {
                sb.append(ch);
                continue;
            }
            if (ch > '\u00ff') {
                sb.append("+");
                continue;
            }
            try {
                sb.append(URLEncoder.encode("" + ch, "UTF-8"));
                continue;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return sb.toString();
    }

    public static String decodeURIComponent(String input) {
        try {
            return URLEncode.decodeURIComponent(input, "UTF-8", true);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return null;
    }

    public static String decodeURIComponent(String input, final String charSet, final boolean ignoreDecodeError) throws UnsupportedEncodingException, IllegalArgumentException {
        return URLEncode.decodeURIComponent(input, new Decoder(){

            @Override
            public String decode(String value) throws UnsupportedEncodingException {
                try {
                    return URLDecoder.decode(value, charSet);
                }
                catch (IllegalArgumentException e) {
                    if (ignoreDecodeError) {
                        return value;
                    }
                    throw e;
                }
            }
        });
    }

    public static String decodeURIComponent(CharSequence input, Decoder decoder) throws UnsupportedEncodingException, IllegalArgumentException {
        if (input == null) {
            return null;
        }
        StringBuilder ret = new StringBuilder();
        StringBuilder sequence = new StringBuilder("");
        int sequenceStep = 0;
        for (int i = 0; i < input.length(); ++i) {
            char nextChar = input.charAt(i);
            if (nextChar == '%') {
                if (sequenceStep == 1 || sequenceStep == 2) {
                    URLEncode.finalizeDecoderSequence(decoder, sequence, ret);
                }
                sequence.append(nextChar);
                sequenceStep = 1;
                continue;
            }
            if ((sequenceStep == 1 || sequenceStep == 2) && (nextChar >= '0' && nextChar <= '9' || nextChar >= 'a' && nextChar <= 'f' || nextChar >= 'A' && nextChar <= 'F')) {
                sequence.append(nextChar);
                ++sequenceStep;
                continue;
            }
            URLEncode.finalizeDecoderSequence(decoder, sequence, ret);
            ret.append(nextChar);
            sequenceStep = 0;
        }
        URLEncode.finalizeDecoderSequence(decoder, sequence, ret);
        return ret.toString();
    }

    private static void finalizeDecoderSequence(Decoder decoder, StringBuilder decode, StringBuilder output) throws UnsupportedEncodingException, IllegalArgumentException {
        if (decode.length() / 3 > 0) {
            int completedSequenceLength = decode.length() / 3 * 3;
            String completedSequence = decode.substring(0, completedSequenceLength);
            decode.delete(0, completedSequenceLength);
            output.append(decoder.decode(completedSequence));
        }
        if (decode.length() > 0) {
            output.append((CharSequence)decode);
            decode.delete(0, decode.length());
        }
    }

    private static boolean encodeURLSegment(StringBuilder buf, StringBuilder output, Encoder encoder) throws UnsupportedEncodingException {
        if (buf.length() > 0) {
            output.append(encoder.encode(buf.toString()));
            buf.delete(0, buf.length());
            return true;
        }
        return false;
    }

    public static String encodeURIComponent(CharSequence input) {
        if (input == null) {
            return null;
        }
        return URLEncode.encodeURIComponent(input, new Encoder(){

            @Override
            public String encode(String value) throws UnsupportedEncodingException {
                return URLEncoder.encode(value, "UTF-8");
            }
        });
    }

    public static String encodeURIComponent(CharSequence input, Encoder encoder) {
        if (input == null) {
            return null;
        }
        try {
            StringBuilder output = new StringBuilder();
            StringBuilder encodeBuffer = new StringBuilder();
            for (int i = 0; i < input.length(); ++i) {
                char ch = input.charAt(i);
                if (ch == ' ') {
                    URLEncode.encodeURLSegment(encodeBuffer, output, encoder);
                    output.append("%20");
                    continue;
                }
                if (RFC3986_RFC_UNRESERVEDCHARACTERS.indexOf(ch) != -1) {
                    URLEncode.encodeURLSegment(encodeBuffer, output, encoder);
                    output.append(ch);
                    continue;
                }
                encodeBuffer.append(ch);
            }
            URLEncode.encodeURLSegment(encodeBuffer, output, encoder);
            return output.toString();
        }
        catch (UnsupportedEncodingException ignore) {
            throw new RuntimeException(ignore);
        }
    }

    public static String encodeURIComponent(String input) {
        return URLEncode.encodeURIComponent((CharSequence)input);
    }

    public static interface Encoder {
        public String encode(String var1) throws UnsupportedEncodingException;
    }

    public static interface Decoder {
        public String decode(String var1) throws UnsupportedEncodingException;
    }
}

