/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.images;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.appwork.utils.Application;
import org.appwork.utils.DebugMode;
import org.appwork.utils.images.AbstractIconPipe;
import org.appwork.utils.images.Interpolation;
import org.appwork.utils.images.ModificationType;
import org.appwork.utils.swing.EDT;

public class DebugIcon
extends AbstractIconPipe {
    private static boolean CTRL_PRESSED = false;
    private static final Set<ModificationType> MODIFICATIONS;

    public DebugIcon(Icon icon) {
        super(icon);
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y, List<Icon> parents) {
        this.paintDelegate(c, g, x, y, parents);
        if (!CTRL_PRESSED) {
            Graphics2D g2d = (Graphics2D)g.create();
            String text = "" + (double)this.getIconWidth() * g2d.getTransform().getScaleX();
            text = text.replaceAll("\\.0$", "");
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, Interpolation.BILINEAR.getHint());
            g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Font baseFont = new Font("SansSerif", 0, this.getIconWidth());
            g2d.setFont(baseFont);
            FontMetrics metrics = g2d.getFontMetrics();
            int textWidth = metrics.stringWidth(text);
            int textHeight = metrics.getAscent() + metrics.getDescent();
            double scaleX = (double)this.getIconWidth() / (double)textWidth;
            double scaleY = (double)this.getIconHeight() / (double)textHeight;
            double scale = Math.min(scaleX, scaleY);
            double scaledTextWidth = (double)textWidth * scale;
            double scaledTextHeight = (double)textHeight * scale;
            double offsetX = ((double)this.getIconWidth() - scaledTextWidth) / 2.0;
            double offsetY = ((double)this.getIconHeight() - scaledTextHeight) / 2.0;
            g2d.translate((double)x + offsetX, (double)y + offsetY);
            g2d.scale(scale, scale);
            FontRenderContext frc = g2d.getFontRenderContext();
            GlyphVector gv = baseFont.createGlyphVector(frc, text);
            Shape textShape = gv.getOutline(0.0f, metrics.getAscent());
            g2d.setStroke(new BasicStroke(3.0f / (float)scale, 1, 1));
            g2d.setColor(Color.WHITE);
            g2d.draw(textShape);
            g2d.setColor(Color.RED);
            g2d.fill(textShape);
            g2d.dispose();
        }
    }

    @Override
    public Set<ModificationType> getModifications() {
        return MODIFICATIONS;
    }

    static {
        if (DebugMode.TRUE_IN_IDE_ELSE_FALSE && !Application.isHeadless()) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(new KeyEventDispatcher(){

                @Override
                public boolean dispatchKeyEvent(KeyEvent e) {
                    if (e.getKeyCode() == 17) {
                        boolean old = CTRL_PRESSED;
                        CTRL_PRESSED = e.getID() == 401;
                        if (old != CTRL_PRESSED) {
                            new EDT<Void, RuntimeException>(){

                                @Override
                                protected Void runInEDT() throws RuntimeException {
                                    for (Window window : Window.getWindows()) {
                                        window.invalidate();
                                        window.validate();
                                        window.repaint();
                                    }
                                    System.out.println("Redraw");
                                    return null;
                                }
                            }.start();
                        }
                    }
                    return false;
                }
            });
        }
        MODIFICATIONS = Collections.unmodifiableSet(new HashSet<ModificationType>(Arrays.asList(ModificationType.OVERLAY)));
    }
}

