/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.logging2;

import java.io.File;
import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class LogSinkFileHandler
extends Handler {
    private final File file;
    private final int maxSize;
    private final int maxLogs;
    private volatile FileHandler fileHandler = null;
    private volatile boolean closed = false;

    public File getFile() {
        return this.file;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public int getMaxLogs() {
        return this.maxLogs;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isOpen() {
        return this.fileHandler != null && !this.closed;
    }

    public LogSinkFileHandler(File file, int maxSize, int maxLogs) {
        this.file = file;
        this.maxSize = maxSize;
        this.maxLogs = maxLogs;
    }

    @Override
    public synchronized void publish(LogRecord record) {
        if (!this.closed) {
            if (this.fileHandler == null) {
                try {
                    this.fileHandler = new FileHandler(this.file.getAbsolutePath(), this.maxSize, this.maxLogs, true){

                        @Override
                        public Formatter getFormatter() {
                            return LogSinkFileHandler.this.getFormatter();
                        }
                    };
                    this.fileHandler.setEncoding("UTF-8");
                    this.fileHandler.setLevel(Level.ALL);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    this.close();
                }
            }
            if (this.fileHandler != null) {
                this.fileHandler.publish(record);
            }
        }
    }

    @Override
    public synchronized void close() throws SecurityException {
        FileHandler fileHandler = this.fileHandler;
        this.fileHandler = null;
        this.closed = true;
        if (fileHandler != null) {
            fileHandler.close();
        }
    }

    @Override
    public synchronized void flush() {
        FileHandler fileHandler = this.fileHandler;
        if (!this.closed && fileHandler != null) {
            fileHandler.flush();
        }
    }
}

