/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.logging2.extmanager;

import java.lang.reflect.Field;
import java.util.Enumeration;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.appwork.utils.ReflectionUtils;
import org.appwork.utils.logging2.ConsoleLogImpl;
import org.appwork.utils.logging2.LogInterface;
import org.appwork.utils.logging2.LogSource;
import org.appwork.utils.logging2.LogSourceProvider;
import org.appwork.utils.logging2.extmanager.DevNullLogger;
import org.appwork.utils.logging2.extmanager.ExtLogManager;

public class LoggerFactory
extends LogSourceProvider {
    private static final LoggerFactory INSTANCE = LoggerFactory.initialize();
    private LogInterface defaultLogInterface = null;
    private LogSourceProvider delegate;
    private final MODE mode;

    private static LoggerFactory initialize() {
        try {
            System.setProperty("extlogmanager.avoidsystemclassloader.hack", ExtLogManager.class.getClassLoader().toString());
            System.setProperty("java.util.logging.manager", ExtLogManager.class.getName());
            LogManager logManager = LogManager.getLogManager();
            ((ExtLogManager)logManager).getClass();
            LoggerFactory instance = new LoggerFactory(MODE.NORMAL);
            ((ExtLogManager)logManager).setLoggerFactory(instance);
            return instance;
        }
        catch (Throwable e) {
            LogManager logManager = LogManager.getLogManager();
            try {
                if (logManager != null) {
                    Field managerField = ReflectionUtils.getField(LogManager.class, "manager", (Object)logManager, LogManager.class);
                    ExtLogManager manager = new ExtLogManager();
                    LoggerFactory instance = new LoggerFactory(MODE.REPLACED);
                    manager.setLoggerFactory(instance);
                    Field modifiersField = ReflectionUtils.getField(Field.class, "modifiers", (Object)managerField, Integer.TYPE);
                    modifiersField.setInt(managerField, managerField.getModifiers() & 0xFFFFFFEF);
                    managerField.set(null, manager);
                    Field rootLoggerField = ReflectionUtils.getField(LogManager.class, "rootLogger", (Object)logManager, Logger.class);
                    Logger rootLoggerInstance = (Logger)rootLoggerField.get(logManager);
                    modifiersField.setInt(rootLoggerField, rootLoggerField.getModifiers() & 0xFFFFFFEF);
                    rootLoggerField.set(manager, rootLoggerInstance);
                    manager.addLogger(rootLoggerInstance);
                    ReflectionUtils.invoke(Logger.class, "setLogManager", (Object)Logger.global, Void.TYPE, manager);
                    Enumeration<String> names = logManager.getLoggerNames();
                    while (names.hasMoreElements()) {
                        manager.addLogger(logManager.getLogger(names.nextElement()));
                    }
                    return instance;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return new LoggerFactory(MODE.FALLBACK);
        }
    }

    public static LoggerFactory I() {
        return INSTANCE;
    }

    public String toString() {
        return "Mode:" + (Object)((Object)this.getMode());
    }

    public LogInterface getDefaultLogInterface() {
        return this.defaultLogInterface;
    }

    public void setDefaultLogInterface(LogInterface defaultLogInterface) {
        this.defaultLogInterface = defaultLogInterface;
    }

    public MODE getMode() {
        return this.mode;
    }

    protected LoggerFactory(MODE mode) {
        super(System.currentTimeMillis());
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                LogSource logger = LoggerFactory.this.getLogger("UncaughtExceptionHandler:" + t.getName());
                logger.severe("Uncaught Exception in: " + t.getId() + "=" + t.getName());
                logger.log(e);
                logger.close();
            }
        });
        this.mode = mode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LogInterface getDefaultLogger() {
        if (INSTANCE == null) {
            if ("true".equalsIgnoreCase(System.getProperty("LOG_NO_CONSOLE"))) {
                return new DevNullLogger();
            }
            return new ConsoleLogImpl();
        }
        LogInterface defaultLogInterface = null;
        LoggerFactory loggerFactory = INSTANCE;
        synchronized (loggerFactory) {
            defaultLogInterface = LoggerFactory.INSTANCE.defaultLogInterface;
            if (defaultLogInterface == null) {
                LoggerFactory.INSTANCE.defaultLogInterface = defaultLogInterface = INSTANCE.getLogger("Log.L");
            }
        }
        return defaultLogInterface;
    }

    @Override
    public LogSource getLogger(String name) {
        LogSourceProvider delegate = this.delegate;
        if (delegate != null) {
            return delegate.getLogger(name);
        }
        return super.getLogger(name);
    }

    public void setDelegate(LogSourceProvider newLogController) {
        this.delegate = newLogController;
    }

    public static LoggerFactory getInstance() {
        return INSTANCE;
    }

    public static LogInterface get(String name) {
        if (INSTANCE == null) {
            return LoggerFactory.getDefaultLogger();
        }
        return INSTANCE.getLogger(name);
    }

    public static void log(LogSource logger, Throwable e) {
        if (logger != null) {
            logger.log(e);
        }
    }

    public static enum MODE {
        NORMAL,
        REPLACED,
        FALLBACK;

    }
}

