/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net.BasicHTTP;

import java.io.IOException;
import org.appwork.utils.StringUtils;
import org.appwork.utils.net.httpconnection.HTTPConnection;

public class InvalidResponseCode
extends IOException {
    public final HTTPConnection connection;
    public final String message;

    public InvalidResponseCode(HTTPConnection connection, String message) {
        super("Invalid ResponseCode: " + connection.getResponseCode());
        this.connection = connection;
        this.message = message;
    }

    public InvalidResponseCode(HTTPConnection connection, Throwable cause) {
        super("Invalid ResponseCode: " + connection.getResponseCode(), cause);
        this.connection = connection;
        this.message = null;
    }

    public InvalidResponseCode(HTTPConnection connection) {
        super("Invalid ResponseCode: " + connection.getResponseCode());
        this.connection = connection;
        this.message = null;
    }

    public HTTPConnection getConnection() {
        return this.connection;
    }

    public String getRawMessage() {
        return this.message;
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append("Invalid ResponseCode: " + this.getCode());
        if (StringUtils.isNotEmpty(this.message)) {
            sb.append("\r\nResponseBody:\r\n").append(this.message);
        }
        return sb.toString();
    }

    public int getCode() {
        try {
            HTTPConnection connection = this.getConnection();
            return connection != null ? connection.getResponseCode() : -1;
        }
        catch (Exception e) {
            return -1;
        }
    }
}

