/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net;

import java.io.IOException;
import java.io.OutputStream;

public class ChunkedOutputStream
extends OutputStream {
    private static final byte[] RN = new byte[]{13, 10};
    private final OutputStream os;
    private final byte[] buffer;
    private int bufUsed = 0;
    boolean closed = false;

    public ChunkedOutputStream(OutputStream os) {
        this(os, 4096);
    }

    public ChunkedOutputStream(OutputStream os, byte[] buffer) {
        this.os = os;
        this.buffer = buffer;
    }

    public ChunkedOutputStream(OutputStream os, int bufSize) {
        this.os = os;
        this.buffer = new byte[bufSize];
    }

    private void _flush(boolean emptyFlush) throws IOException {
        if (!this.closed && (this.bufUsed > 0 || emptyFlush)) {
            byte[] bytes = Integer.toHexString(this.bufUsed).getBytes();
            this.os.write(bytes);
            this.os.write(RN);
            if (this.bufUsed > 0 || emptyFlush) {
                if (this.bufUsed > 0) {
                    this.os.write(this.buffer, 0, this.bufUsed);
                }
                this.os.write(RN);
            }
            this.bufUsed = 0;
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (!this.closed) {
            this.sendEOF();
            this.closed = true;
        }
        this.os.close();
    }

    @Override
    public synchronized void flush() throws IOException {
        this._flush(false);
        this.os.flush();
    }

    public synchronized void sendEOF() throws IOException {
        this._flush(false);
        this._flush(true);
        this.os.flush();
        this.closed = true;
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return;
        }
        if (this.bufUsed + len < this.buffer.length) {
            System.arraycopy(b, off, this.buffer, this.bufUsed, len);
            this.bufUsed += len;
        } else {
            byte[] bytes = Integer.toHexString(this.bufUsed + len).getBytes();
            this.os.write(bytes);
            this.os.write(RN);
            if (this.bufUsed > 0) {
                this.os.write(this.buffer, 0, this.bufUsed);
                this.bufUsed = 0;
            }
            this.os.write(b, off, len);
            this.os.write(RN);
        }
    }

    @Override
    public synchronized void write(int b) throws IOException {
        if (this.bufUsed == this.buffer.length) {
            byte[] bytes = Integer.toHexString(this.buffer.length).getBytes();
            this.os.write(bytes);
            this.os.write(RN);
            this.os.write(this.buffer);
            this.os.write(RN);
            this.bufUsed = 0;
        }
        this.buffer[this.bufUsed++] = (byte)b;
    }
}

