/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net;

import java.io.IOException;
import java.io.InputStream;
import org.appwork.utils.net.CountingInputStream;
import org.appwork.utils.net.StreamValidEOF;

public class LimitedInputStream
extends CountingInputStream
implements StreamValidEOF {
    private final long limit;
    protected final byte[] skipBuffer = new byte[Short.MAX_VALUE];

    public LimitedInputStream(InputStream in, long limit) {
        super(in);
        this.limit = limit;
    }

    public long getLimit() {
        return this.limit;
    }

    @Override
    public int read() throws IOException {
        if (this.transferedBytes() >= this.getLimit()) {
            return -1;
        }
        return super.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        long left = this.getLimit() - this.transferedBytes();
        if (left == 0L) {
            return -1;
        }
        if (left < (long)len) {
            len = (int)left;
        }
        return super.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        if (n < (long)this.skipBuffer.length) {
            return this.read(this.skipBuffer, 0, (int)n);
        }
        return this.read(this.skipBuffer);
    }

    @Override
    public boolean isValidEOF() {
        return this.transferedBytes() == this.getLimit();
    }
}

