/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net.ftpserver;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import org.appwork.utils.net.ftpserver.FtpConnection;
import org.appwork.utils.net.ftpserver.FtpConnectionHandler;
import org.appwork.utils.net.ftpserver.FtpFile;
import org.appwork.utils.net.httpconnection.HTTPConnectionUtils;

public class FtpServer
implements Runnable {
    private final FtpConnectionHandler<? extends FtpFile> handler;
    private final int port;
    private ServerSocket controlSocket;
    private Thread controlThread = null;
    private ThreadGroup threadGroup = null;
    private boolean localhostOnly = false;
    private boolean debug = false;

    public FtpServer(FtpConnectionHandler<? extends FtpFile> handler, int port) {
        this.handler = handler;
        this.port = port;
        this.threadGroup = new ThreadGroup("FTPServer");
    }

    public FtpConnectionHandler<? extends FtpFile> getFtpCommandHandler() {
        return this.handler;
    }

    protected InetAddress getLocalHost() throws UnknownHostException {
        return HTTPConnectionUtils.getLoopback(HTTPConnectionUtils.IPVERSION.IPV4_IPV6)[0];
    }

    protected ThreadGroup getThreadGroup() {
        return this.threadGroup;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isLocalhostOnly() {
        return this.localhostOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Thread current = this.controlThread;
        ServerSocket socket = this.controlSocket;
        try {
            do {
                try {
                    Socket clientSocket = socket.accept();
                    new FtpConnection(this, clientSocket);
                }
                catch (IOException e) {
                    break;
                }
            } while (current != null && !current.isInterrupted());
        }
        finally {
            try {
                socket.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setLocalhostOnly(boolean localhostOnly) {
        this.localhostOnly = localhostOnly;
    }

    public synchronized void start() throws IOException {
        if (this.isLocalhostOnly()) {
            InetSocketAddress socketAddress = new InetSocketAddress(this.getLocalHost(), this.port);
            this.controlSocket = new ServerSocket();
            this.controlSocket.bind(socketAddress);
        } else {
            this.controlSocket = new ServerSocket(this.port);
        }
        this.controlThread = new Thread(this.threadGroup, this);
        this.controlThread.setName("FtpServerThread");
        this.controlThread.start();
    }

    public synchronized void stop() {
        try {
            this.controlSocket.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.threadGroup.interrupt();
    }
}

