/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net.ssl;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.Security;
import org.appwork.utils.net.ssl.CryptServiceProvider;

public final class TrustProvider
extends Provider {
    private static final long serialVersionUID = 3537609645240163218L;
    private static final String PROVIDER_NAME = "AppWTrust";
    private static String origAlgorithm;
    private static final String PROVIDER_DESCRIPTION = "AppWork TrustProvider";

    public static String getProviderName() {
        return PROVIDER_NAME;
    }

    public static String getProviderDescription() {
        return PROVIDER_DESCRIPTION;
    }

    public TrustProvider() {
        super(PROVIDER_NAME, 0.1, PROVIDER_DESCRIPTION);
        this.init();
    }

    private void init() {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                TrustProvider.this.put("TrustManagerFactory." + CryptServiceProvider.getAlgorithm(), CryptServiceProvider.class.getName());
                return null;
            }
        });
    }

    public static void register() {
        if (Security.getProvider(PROVIDER_NAME) == null) {
            Security.insertProviderAt(new TrustProvider(), 2);
            origAlgorithm = System.getProperty("ssl.TrustManagerFactory.algorithm");
            Security.setProperty("ssl.TrustManagerFactory.algorithm", CryptServiceProvider.getAlgorithm());
        }
    }

    public static void unRegister() {
        if (origAlgorithm != null) {
            Security.setProperty("ssl.TrustManagerFactory.algorithm", origAlgorithm);
            origAlgorithm = null;
            Security.removeProvider(TrustProvider.getProviderName());
        }
    }
}

