/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.processes.command;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.appwork.loggingv3.LogV3;
import org.appwork.utils.parser.ShellParser;
import org.appwork.utils.processes.ProcessBuilderFactory;
import org.appwork.utils.processes.command.AsyncInputStreamHandler;
import org.appwork.utils.processes.command.OutputHandler;
import org.appwork.utils.processes.command.ProcessErrorStream;
import org.appwork.utils.processes.command.ProcessInputStream;

public class Command {
    protected final ProcessBuilder builder;
    private OutputHandler lineHandler;
    private Process process;
    private int exitCode = -1;
    public final String[] commandline;
    protected final List<AsyncInputStreamHandler> asyncTasks = new ArrayList<AsyncInputStreamHandler>();
    protected Charset charset;

    public int getExitCode() {
        return this.exitCode;
    }

    public Command(String ... cmds) {
        this.commandline = cmds;
        this.builder = ProcessBuilderFactory.create(cmds);
        try {
            this.charset = Charset.forName(ProcessBuilderFactory.getConsoleCodepage());
        }
        catch (InterruptedException e) {
            this.charset = Charset.defaultCharset();
            Thread.currentThread().interrupt();
        }
    }

    public Command(List<String> cmds) {
        this(cmds.toArray(new String[0]));
    }

    public Command(String cmdLine) {
        this(ShellParser.splitCommandString(cmdLine));
    }

    public Command setOutputHandler(OutputHandler lineHandler) {
        this.checkRunning();
        this.lineHandler = lineHandler;
        return this;
    }

    public Command setCharset(Charset charset) {
        this.checkRunning();
        if (charset == null) {
            throw new IllegalArgumentException("charset is null!");
        }
        this.charset = charset;
        return this;
    }

    public Command start(boolean closeOutputStream) throws IOException, InterruptedException {
        OutputHandler lh;
        this.process = this.builder.start();
        if (closeOutputStream) {
            this.process.getOutputStream().close();
        }
        if ((lh = this.lineHandler) != null) {
            this.asyncTasks.add(lh.createAsyncStreamHandler(new ProcessInputStream(this.process), this.getCharset()));
            this.asyncTasks.add(lh.createAsyncStreamHandler(new ProcessErrorStream(this.process), this.getCharset()));
        }
        for (AsyncInputStreamHandler task : this.asyncTasks) {
            task.start();
        }
        return this;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public int waitFor() throws InterruptedException, IOException {
        Process process = this.getProcess();
        if (process == null) {
            throw new IllegalStateException("Process not yet started!");
        }
        Integer exitCode = null;
        try {
            exitCode = process.waitFor();
            this.exitCode = exitCode;
            int n = exitCode;
            return n;
        }
        catch (InterruptedException e) {
            for (AsyncInputStreamHandler task : this.asyncTasks) {
                task.interrupt();
            }
            throw e;
        }
        finally {
            this.killProcessOnException(process);
            if (this.lineHandler != null && exitCode != null) {
                this.lineHandler.onExitCode(exitCode);
            }
            for (AsyncInputStreamHandler task : this.asyncTasks) {
                if (exitCode != null) {
                    task.onExit(exitCode);
                }
                task.waitFor();
            }
        }
    }

    protected void killProcessOnException(Process process) {
        try {
            process.destroy();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Command setDirectory(File directory) {
        this.checkRunning();
        this.builder.directory(directory);
        return this;
    }

    public Process getProcess() {
        return this.process;
    }

    protected void checkRunning() {
        if (this.getProcess() != null) {
            throw new IllegalStateException("Process already running. You have to do this  BEFORE calling #start()");
        }
    }

    public Command putEnvironMent(String key, String value) {
        if (key == null || value == null) {
            LogV3.warning(key + "=" + value + " NullPointer Protection!");
            return this;
        }
        this.checkRunning();
        this.builder.environment().put(key, value);
        return this;
    }

    public void destroy() {
        Process process = this.getProcess();
        if (process != null) {
            process.destroy();
        }
    }

    public boolean isAlive() {
        Process p = this.getProcess();
        if (p == null) {
            return false;
        }
        try {
            p.exitValue();
            return false;
        }
        catch (IllegalThreadStateException e) {
            return true;
        }
    }

    public void putAllEnvironment(Map<String, String> map) {
        for (Map.Entry<String, String> es : map.entrySet()) {
            this.putEnvironMent(es.getKey(), es.getValue());
        }
    }
}

