/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.text.JTextComponent;
import org.appwork.loggingv3.LogV3;
import org.appwork.utils.StringUtils;

public class SwingUtils {
    public static Point getCenter(Component parentFrame, Window frame) {
        Point point = new Point();
        if (parentFrame == null || frame == null) {
            point.setLocation(0, 0);
        } else {
            int x = parentFrame.getLocation().x + parentFrame.getSize().width / 2 - frame.getSize().width / 2;
            int y = parentFrame.getLocation().y + parentFrame.getSize().height / 2 - frame.getSize().height / 2;
            point.setLocation(x, y);
        }
        return point;
    }

    public static JComponent getComponentByName(JComponent frame, String name) {
        JComponent ret = null;
        for (Component c : frame.getComponents()) {
            if (!(c instanceof JComponent)) continue;
            if (c.getName() != null && c.getName().equals(name)) {
                return (JComponent)c;
            }
            ret = SwingUtils.getComponentByName((JComponent)c, name);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    public static Window getWindowForComponent(Component parentComponent) {
        if (parentComponent == null) {
            return JOptionPane.getRootFrame();
        }
        if (parentComponent instanceof Frame || parentComponent instanceof Dialog) {
            return (Window)parentComponent;
        }
        return SwingUtils.getWindowForComponent(parentComponent.getParent());
    }

    public static JComponent setOpaque(JComponent descriptionField, boolean b) {
        descriptionField.setOpaque(b);
        descriptionField.putClientProperty("Synthetica.opaque", b ? Boolean.TRUE : Boolean.FALSE);
        return descriptionField;
    }

    public static <T extends AbstractButton> T toBold(T button) {
        Font f = button.getFont();
        button.setFont(f.deriveFont(f.getStyle() ^ 1));
        return button;
    }

    public static <T extends JLabel> T toBold(T label) {
        Font f = label.getFont();
        label.setFont(f.deriveFont(f.getStyle() ^ 1));
        return label;
    }

    public static <T extends JTextComponent> T toBold(T label) {
        Font f = label.getFont();
        label.setFont(f.deriveFont(f.getStyle() ^ 1));
        return label;
    }

    public static void printComponentTree(JComponent fc) {
        SwingUtils.printComponentTree(fc, "");
    }

    private static void printComponentTree(JComponent fc, String string) {
        for (int i = 0; i < fc.getComponentCount(); ++i) {
            Component cc = fc.getComponent(i);
            System.out.println(string + "[" + i + "]" + cc.getClass().getSuperclass().getSimpleName() + ":" + cc + " Opaque: " + cc.isOpaque());
            if (!(cc instanceof JComponent)) continue;
            SwingUtils.printComponentTree((JComponent)cc, string + "[" + i + "]");
        }
    }

    public static <T> Map<T, List<Integer>> find(Component c, Map<T, List<Integer>> map, Class<T> search) {
        List<Integer> path = null;
        if (map == null) {
            map = new HashMap<T, List<Integer>>();
        }
        if ((path = map.get(null)) == null) {
            path = new ArrayList<Integer>();
        }
        if (search.isAssignableFrom(c.getClass())) {
            map.put(c, path);
        } else if (c instanceof Container) {
            Container co = (Container)c;
            for (int index = 0; index < co.getComponentCount(); ++index) {
                ArrayList<Integer> nextPath = new ArrayList<Integer>(path);
                nextPath.add(index);
                HashMap<T, List<Integer>> nextMap = new HashMap<T, List<Integer>>(map);
                nextMap.put(null, nextPath);
                Map<T, List<Integer>> ret = SwingUtils.find(co.getComponent(index), nextMap, search);
                if (ret == null) continue;
                map = ret;
            }
        }
        map.remove(null);
        if (map.size() > 0) {
            return map;
        }
        return null;
    }

    public static JComponent getParent(JComponent parent, int ... path) {
        for (int i : path) {
            parent = (JComponent)parent.getComponent(i);
        }
        return parent;
    }

    public static GraphicsDevice getScreenByLocation(Point location) {
        GraphicsDevice[] screens;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (GraphicsDevice screen : screens = ge.getScreenDevices()) {
            Rectangle bounds = screen.getDefaultConfiguration().getBounds();
            if (!bounds.contains(location)) continue;
            return screen;
        }
        return null;
    }

    public static GraphicsDevice getScreenByLocation(int x, int y) {
        return SwingUtils.getScreenByLocation(new Point(x, y));
    }

    public static Rectangle getUsableScreenBounds(GraphicsDevice screen) {
        GraphicsConfiguration configuration = screen.getDefaultConfiguration();
        Rectangle bounds = configuration.getBounds();
        Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(configuration);
        bounds.x += insets.left;
        bounds.y += insets.top;
        bounds.width -= insets.left + insets.right;
        bounds.height -= insets.top + insets.bottom;
        return bounds;
    }

    public static boolean isRectangleFullyDisplayableOnScreens(Rectangle bounds) {
        GraphicsDevice[] screens;
        Area p = new Area(bounds);
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (GraphicsDevice screen : screens = ge.getScreenDevices()) {
            Rectangle usableBounds = SwingUtils.getUsableScreenBounds(screen);
            p.subtract(new Area(usableBounds));
            if (!p.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public static GraphicsDevice getScreenByBounds(Rectangle bounds) {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] screens = ge.getScreenDevices();
        Rectangle biggestIntersection = null;
        GraphicsDevice bestScreenByBounds = null;
        for (GraphicsDevice screen : screens) {
            Rectangle screenBounds = screen.getDefaultConfiguration().getBounds();
            Rectangle intersection = screenBounds.intersection(bounds);
            if (intersection == null || intersection.width <= 0 || intersection.height <= 0 || biggestIntersection != null && intersection.width * intersection.height <= biggestIntersection.width * biggestIntersection.height) continue;
            biggestIntersection = intersection;
            bestScreenByBounds = screen;
            if (intersection.equals(bounds)) break;
        }
        return bestScreenByBounds;
    }

    public static Rectangle2D getStringSizeForFont(String string, Font font) {
        if (font == null) {
            return null;
        }
        if (string == null || string.length() == 0) {
            return new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
        }
        FontRenderContext fontRenderContext = new FontRenderContext(new AffineTransform(), true, true);
        double width = font.getStringBounds(string, fontRenderContext).getWidth();
        double height = font.getStringBounds(string, fontRenderContext).getHeight();
        return new Rectangle2D.Double(0.0, 0.0, width, height);
    }

    public static GraphicsDevice getScreenByID(String screenID) {
        GraphicsDevice[] screens;
        if (StringUtils.isEmpty(screenID)) {
            return null;
        }
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (GraphicsDevice screen : screens = ge.getScreenDevices()) {
            if (!StringUtils.equals(screen.getIDstring(), screenID)) continue;
            return screen;
        }
        return null;
    }

    public static void invokeLater(final Runnable runnable, int delayInMS) {
        if (delayInMS <= 0) {
            SwingUtilities.invokeLater(runnable);
        } else {
            Timer timer = new Timer(delayInMS, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    runnable.run();
                }
            });
            timer.setRepeats(false);
            timer.start();
        }
    }

    public static Point convertToUnscaled(GraphicsDevice device, Point target) {
        GraphicsDevice[] screens;
        GraphicsDevice[] graphicsDeviceArray;
        if (device != null) {
            GraphicsDevice[] graphicsDeviceArray2 = new GraphicsDevice[1];
            graphicsDeviceArray = graphicsDeviceArray2;
            graphicsDeviceArray2[0] = device;
        } else {
            graphicsDeviceArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        }
        for (GraphicsDevice screen : screens = graphicsDeviceArray) {
            Point point = target;
            GraphicsConfiguration screenConfiguration = screen.getDefaultConfiguration();
            AffineTransform transformation = screenConfiguration.getDefaultTransform();
            Point2D p2d = transformation.transform(target, null);
            point = new Point((int)p2d.getX(), (int)p2d.getY());
            if (device != null) {
                return point;
            }
            Rectangle bounds = screenConfiguration.getBounds();
            if (!bounds.contains(point)) continue;
            return point;
        }
        return null;
    }

    public static Point convertToScaled(Point target, GraphicsDevice device) {
        GraphicsDevice[] screens;
        GraphicsDevice[] graphicsDeviceArray;
        if (device != null) {
            GraphicsDevice[] graphicsDeviceArray2 = new GraphicsDevice[1];
            graphicsDeviceArray = graphicsDeviceArray2;
            graphicsDeviceArray2[0] = device;
        } else {
            graphicsDeviceArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        }
        for (GraphicsDevice screen : screens = graphicsDeviceArray) {
            Point point = target;
            GraphicsConfiguration screenConfiguration = screen.getDefaultConfiguration();
            try {
                AffineTransform transformation = screenConfiguration.getDefaultTransform();
                Point2D p2d = transformation.inverseTransform(target, null);
                point = new Point((int)p2d.getX(), (int)p2d.getY());
            }
            catch (NoninvertibleTransformException e1) {
                LogV3.log(e1);
            }
            if (device != null) {
                return point;
            }
            Rectangle bounds = screenConfiguration.getBounds();
            if (!bounds.contains(point)) continue;
            return point;
        }
        return null;
    }
}

