/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.swing.dialog;

import java.awt.event.ActionEvent;
import java.util.concurrent.atomic.AtomicLong;
import org.appwork.utils.swing.EDTHelper;
import org.appwork.utils.swing.dialog.AbstractDialog;
import org.appwork.utils.swing.dialog.ConfirmDialog;
import org.appwork.utils.swing.dialog.Dialog;
import org.appwork.utils.swing.dialog.DialogCanceledException;
import org.appwork.utils.swing.dialog.DialogClosedException;

public class AbstractTimerThread
extends Thread {
    private final AbstractDialog<?> dialog;
    private final AtomicLong counter = new AtomicLong(0L);

    public static void main(String[] args) throws DialogClosedException, DialogCanceledException {
        Dialog.getInstance().setDefaultTimeout(30000);
        Dialog.getInstance().showDialog(new ConfirmDialog(4, "TimerTest", "TimerTest", null, "close", "reset"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == this.okButton) {
                    super.actionPerformed(e);
                } else {
                    this.resetTimer();
                }
            }
        });
    }

    public AbstractTimerThread(AbstractDialog<?> dialog) {
        this.dialog = dialog;
        this.reset();
        this.setDaemon(true);
        this.setName("DialogTimer: " + dialog);
    }

    protected boolean isCurrentTimer() {
        return this.dialog.getTimer().get() == this;
    }

    protected boolean isVisible() {
        return Boolean.TRUE.equals(new EDTHelper<Boolean>(){

            @Override
            public Boolean edtRun() {
                return AbstractTimerThread.this.dialog.isVisible();
            }
        }.getReturnValue());
    }

    public void reset() {
        long timeout = this.dialog.getCountdown();
        if (timeout <= 0L) {
            throw new IllegalArgumentException("timeout is invalid " + timeout);
        }
        this.counter.set(timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (!this.isVisible() && this.isCurrentTimer()) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    this.dialog.getTimer().compareAndSet(this, null);
                    return;
                }
            }
            long currentTimeout = this.counter.get();
            while (!this.dialog.isExpired(currentTimeout) && this.isCurrentTimer() && this.isVisible()) {
                final String left = this.dialog.formatCountdown(currentTimeout);
                new EDTHelper<Object>(){

                    @Override
                    public Object edtRun() {
                        ((AbstractTimerThread)AbstractTimerThread.this).dialog.timerLbl.setText(left);
                        return null;
                    }
                }.start();
                Thread.sleep(1000L);
                if (this.counter.compareAndSet(currentTimeout, currentTimeout - 1000L)) {
                    currentTimeout -= 1000L;
                    continue;
                }
                currentTimeout = this.counter.get();
            }
            if (this.isCurrentTimer() && this.isVisible() && !this.isInterrupted()) {
                this.dialog.onTimeout();
            }
        }
        catch (InterruptedException e) {
            return;
        }
        finally {
            this.dialog.getTimer().compareAndSet(this, null);
        }
    }
}

