/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.swing.dialog;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import javax.swing.Icon;
import javax.swing.filechooser.FileSystemView;
import org.appwork.loggingv3.LogV3;
import org.appwork.storage.config.JsonConfig;
import org.appwork.sunwrapper.sun.awt.shell.ShellFolderWrapper;
import org.appwork.utils.locale._AWU;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.swing.dialog.ExtFileChooserDialogIcon;
import org.appwork.utils.swing.dialog.ExtFileSystemViewSettings;
import org.appwork.utils.swing.dialog.HomeFolder;
import org.appwork.utils.swing.dialog.NetWorkFolder;
import org.appwork.utils.swing.dialog.VirtualRoot;

public class ExtFileSystemView
extends FileSystemView {
    public static boolean SAMBA_SCANNED = false;
    private final FileSystemView org = FileSystemView.getFileSystemView();
    private File[] roots;
    private NetWorkFolder networkFolder;
    private HashMap<File, File> specialsMap;
    private final boolean useFileIcons;
    public static final String VIRTUAL_NETWORKFOLDER = "::{F02C1A0D-BE21-4350-88B0-7367FC96EF3C}";
    public static final String VIRTUAL_NETWORKFOLDER_XP = "::{208D2C60-3AEA-1069-A2D7-08002B30309D}";

    public static void runSambaScanner() {
        if (SAMBA_SCANNED) {
            return;
        }
        SAMBA_SCANNED = true;
    }

    public ExtFileSystemView() {
        if (!SAMBA_SCANNED) {
            new Exception("run ExtFileSystemView.runSambaScanner() as early as possible in your app!");
            ExtFileSystemView.runSambaScanner();
        }
        this.useFileIcons = JsonConfig.create(ExtFileSystemViewSettings.class).isUseSystemIcons();
    }

    @Override
    public File createFileObject(File dir, String filename) {
        return this.org.createFileObject(dir, filename);
    }

    @Override
    public File createFileObject(String path) {
        return this.org.createFileObject(path);
    }

    @Override
    public File createNewFolder(File containingDir) throws IOException {
        return this.org.createNewFolder(containingDir);
    }

    @Override
    public File getChild(File parent, String fileName) {
        return this.org.getChild(parent, fileName);
    }

    @Override
    public File getDefaultDirectory() {
        return this.org.getDefaultDirectory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File[] getFiles(File dir, boolean useFileHiding) {
        long t = System.currentTimeMillis();
        try {
            File[] ret;
            if (dir == this.networkFolder) {
                LogV3.I().getDefaultLogger().info("getFilesShellfolder");
                ret = this.getFilesShellfolder((NetWorkFolder)dir, useFileHiding);
            } else {
                LogV3.I().getDefaultLogger().info("org.getFiles(dir, useFileHiding);");
                ret = this.org.getFiles(dir, useFileHiding);
            }
            LogV3.I().getDefaultLogger().info("getFiles: ms:" + (System.currentTimeMillis() - t) + " " + dir + "|" + ret.length);
            ArrayList<File> filtered = new ArrayList<File>();
            for (File f : ret) {
                if (f.getName().equals(VIRTUAL_NETWORKFOLDER)) {
                    filtered.add(new NetWorkFolder(f));
                    continue;
                }
                if (f.getName().equals(VIRTUAL_NETWORKFOLDER_XP)) {
                    filtered.add(new NetWorkFolder(f));
                    continue;
                }
                if (f.getName().startsWith("::{")) continue;
                filtered.add(f);
            }
            LogV3.I().getDefaultLogger().info("Return Files for " + dir + "(" + useFileHiding + "): " + filtered.size());
            File[] fileArray = filtered.toArray(new File[0]);
            return fileArray;
        }
        finally {
            LogV3.I().getDefaultLogger().info("getFiles(end): ms:" + (System.currentTimeMillis() - t) + " " + dir);
        }
    }

    public File[] getFilesShellfolder(NetWorkFolder network, boolean useFileHiding) {
        ArrayList<File> files = new ArrayList<File>();
        File[] names = network.listFiles(useFileHiding);
        if (names == null) {
            return new File[0];
        }
        for (File f : names) {
            if (Thread.currentThread().isInterrupted()) break;
            if (!ShellFolderWrapper.isInstanceof(f)) {
                if (this.isFileSystemRoot(f)) {
                    f = this.createFileSystemRoot(f);
                }
                try {
                    f = ShellFolderWrapper.getShellFolderIfAvailable(f);
                }
                catch (FileNotFoundException e) {
                    continue;
                }
                catch (InternalError e) {
                    continue;
                }
            }
            if (useFileHiding && this.isHiddenFile(f)) continue;
            files.add(f);
        }
        return files.toArray(new File[files.size()]);
    }

    @Override
    public File getHomeDirectory() {
        return this.org.getHomeDirectory();
    }

    public NetWorkFolder getNetworkFolder() {
        return this.networkFolder;
    }

    @Override
    public File getParentDirectory(File dir) {
        return this.org.getParentDirectory(dir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File[] getRoots() {
        long t = System.currentTimeMillis();
        LogV3.I().getDefaultLogger().info("Get Roots");
        if (this.roots != null) {
            return this.roots;
        }
        try {
            File[] baseFolders = this.getBaseFolders();
            LogV3.I().getDefaultLogger().info("Listed Base folders " + (System.currentTimeMillis() - t) + "|" + (baseFolders != null ? baseFolders.length : -1));
            LinkedHashSet<File> unique = new LinkedHashSet<File>(){

                @Override
                public boolean add(File e) {
                    if (this.contains(e)) {
                        return false;
                    }
                    return super.add(e);
                }
            };
            File desktopPath = new File(System.getProperty("user.home") + "/Desktop");
            if (desktopPath.exists() && desktopPath.isDirectory()) {
                unique.add(desktopPath);
            }
            this.mount(new File("/Volumes"), unique);
            this.mount(new File("/media"), unique);
            String userName = System.getProperty("user.name");
            if (userName != null) {
                this.mount(new File("/run/media/" + userName), unique);
            }
            HomeFolder[] homeFolders = new HomeFolder[]{new HomeFolder("", ExtFileChooserDialogIcon.FILECHOOSER_HOME.path()), new HomeFolder("Documents", ExtFileChooserDialogIcon.FILECHOOSER_DOCUMENTS.path()), new HomeFolder("Dropbox", ExtFileChooserDialogIcon.FILECHOOSER_BOX.path()), new HomeFolder("Pictures", ExtFileChooserDialogIcon.FILECHOOSER_IMAGES.path()), new HomeFolder("Videos", ExtFileChooserDialogIcon.FILECHOOSER_VIDEO.path()), new HomeFolder("Downloads", ExtFileChooserDialogIcon.FILECHOOSER_DOWNLOADS.path()), new HomeFolder("Music", ExtFileChooserDialogIcon.FILECHOOSER_MUSIC.path())};
            for (HomeFolder hf : homeFolders) {
                if (!hf.exists()) continue;
                unique.add(hf);
            }
            if (baseFolders != null) {
                for (File f : baseFolders) {
                    if (f.getName().equals("Recent")) continue;
                    if (f.getName().equals(VIRTUAL_NETWORKFOLDER)) {
                        this.networkFolder = new NetWorkFolder(f);
                        break;
                    }
                    if (!f.getName().equals(VIRTUAL_NETWORKFOLDER_XP)) continue;
                    this.networkFolder = new NetWorkFolder(f);
                    break;
                }
            }
            if (this.networkFolder != null) {
                unique.add(this.networkFolder);
            }
            File home = this.getHomeDirectory();
            if (baseFolders != null) {
                for (File f : baseFolders) {
                    if (f.getName().equals("Recent")) continue;
                    if (f.getParentFile() == null || !f.getParentFile().equals(home)) {
                        unique.add(f);
                    }
                    LogV3.I().getDefaultLogger().info("Basefolder: " + f.getName() + " - " + f + " - " + CrossSystem.getOSString());
                }
            }
            File[] nroots = unique.toArray(new File[0]);
            HashMap<File, File> nspecialsMap = new HashMap<File, File>();
            for (File f : nroots) {
                nspecialsMap.put(f, f);
            }
            this.specialsMap = nspecialsMap;
            this.roots = nroots;
            File[] fileArray = this.roots;
            return fileArray;
        }
        finally {
            LogV3.I().getDefaultLogger().info("Roots: " + (System.currentTimeMillis() - t));
        }
    }

    private File[] getBaseFolders() {
        return AccessController.doPrivileged(new PrivilegedAction<File[]>(){

            @Override
            public File[] run() {
                try {
                    return (File[])ShellFolderWrapper.get("fileChooserComboBoxFolders");
                }
                catch (Throwable e) {
                    LogV3.I().getDefaultLogger().log(e);
                    return null;
                }
            }
        });
    }

    @Override
    public String getSystemDisplayName(File f) {
        if (f == this.networkFolder) {
            return _AWU.T.DIALOG_FILECHOOSER_networkfolder();
        }
        if (f instanceof VirtualRoot) {
            return f.getName();
        }
        File shellFolder = ShellFolderWrapper.getInstanceShellFolder(f);
        if (shellFolder != null) {
            return this.org.getSystemDisplayName(shellFolder);
        }
        return this.org.getSystemDisplayName(f);
    }

    @Override
    public Icon getSystemIcon(File f) {
        try {
            if (f instanceof VirtualRoot) {
                return ((VirtualRoot)f).getIcon(18);
            }
            if (this.useFileIcons) {
                File shellFolder = ShellFolderWrapper.getInstanceShellFolder(f);
                if (shellFolder != null) {
                    return this.org.getSystemIcon(shellFolder);
                }
                return this.org.getSystemIcon(f);
            }
            if (f.isDirectory()) {
                return ExtFileChooserDialogIcon.EXTFILESYSTEM_folder.get(18);
            }
            return ExtFileChooserDialogIcon.EXTFILESYSTEM_fileIcon.get(18);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public String getSystemTypeDescription(File f) {
        return this.org.getSystemTypeDescription(f);
    }

    @Override
    public boolean isComputerNode(File dir) {
        return this.org.isComputerNode(dir);
    }

    @Override
    public boolean isDrive(File dir) {
        return this.org.isDrive(dir);
    }

    @Override
    public boolean isFileSystem(File f) {
        return this.org.isFileSystem(f);
    }

    @Override
    public boolean isFileSystemRoot(File dir) {
        return this.org.isFileSystemRoot(dir);
    }

    @Override
    public boolean isFloppyDrive(File dir) {
        return this.org.isFloppyDrive(dir);
    }

    @Override
    public boolean isHiddenFile(File f) {
        return this.org.isHiddenFile(f);
    }

    @Override
    public boolean isParent(File folder, File file) {
        boolean ret = this.org.isParent(folder, file);
        return ret;
    }

    @Override
    public boolean isRoot(File f) {
        return this.org.isRoot(f);
    }

    @Override
    public Boolean isTraversable(File f) {
        return this.org.isTraversable(f);
    }

    public File mapSpecialFolders(File f) {
        if (this.specialsMap == null) {
            return f;
        }
        File ret = this.specialsMap.get(f);
        return ret != null ? ret : f;
    }

    private void mount(File path, LinkedHashSet<File> files) {
        File[] content;
        if (path.exists() && path.isDirectory() && (content = path.listFiles()) != null) {
            for (File f : content) {
                if (f.isHidden()) continue;
                VirtualRoot vFile = new VirtualRoot(f, f.getName());
                files.add(vFile);
            }
        }
    }
}

