/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.swing.dialog;

import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.Timer;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.appwork.swing.MigPanel;
import org.appwork.utils.BinaryLogic;
import org.appwork.utils.InterruptibleThread;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.swing.EDTHelper;
import org.appwork.utils.swing.dialog.AbstractDialog;
import org.appwork.utils.swing.dialog.ProgressInterface;

public class ProgressDialog
extends AbstractDialog<Integer>
implements ProgressInterface {
    private Thread executer;
    protected ProgressGetter getter;
    private final String message;
    private Timer updater;
    private long waitForTermination = 20000L;
    protected Throwable throwable = null;
    private JLabel lbl;
    protected JTextPane textField;

    public ProgressDialog(ProgressGetter progressGetter, int flags, String title, String message, Icon icon) {
        this(progressGetter, flags, title, message, icon, null, null);
    }

    public ProgressDialog(ProgressGetter progressGetter, int flags, String title, String message, Icon icon, String ok, String cancel) {
        super(flags | 8, title, icon, ok, cancel);
        this.message = message;
        this.getter = progressGetter == null && this instanceof ProgressGetter ? (ProgressGetter)((Object)this) : progressGetter;
        this.setReturnmask(true);
    }

    @Override
    protected Integer createReturnValue() {
        return this.getReturnmask();
    }

    @Override
    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        System.out.println("Dispose Progressdialog");
        if (this.executer.isAlive()) {
            this.executer.interrupt();
            long waitFor = this.getWaitForTermination();
            if (waitFor > 0L) {
                try {
                    this.executer.join(waitFor);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        super.dispose();
    }

    protected void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            CrossSystem.openURL(e.getURL());
        }
    }

    protected void addMessageComponent(MigPanel p) {
        this.textField = new JTextPane(){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean getScrollableTracksViewportWidth() {
                return !BinaryLogic.containsAll(ProgressDialog.this.flagMask, 64);
            }
        };
        this.modifyTextPane(this.textField);
        Font font = this.textField.getFont();
        if (BinaryLogic.containsAll(this.flagMask, 128)) {
            this.textField.setContentType("text/html");
            this.textField.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    ProgressDialog.this.hyperlinkUpdate(e);
                }
            });
        } else {
            this.textField.setContentType("text/plain");
        }
        this.textField.setFont(font);
        this.textField.setText(this.message);
        this.textField.setEditable(false);
        this.textField.setBackground(null);
        this.textField.setOpaque(false);
        this.textField.setFocusable(false);
        this.textField.putClientProperty("Synthetica.opaque", Boolean.FALSE);
        this.textField.setCaretPosition(0);
        if (BinaryLogic.containsAll(this.flagMask, 64)) {
            p.add((Component)new JScrollPane(this.textField), "pushx,growx,spanx");
        } else {
            p.add((Component)this.textField, "pushx,growx,spanx");
        }
    }

    private void modifyTextPane(JTextPane textField2) {
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public long getWaitForTermination() {
        return this.waitForTermination;
    }

    @Override
    public JComponent layoutDialogContent() {
        this.getDialog().setDefaultCloseOperation(0);
        MigPanel p = new MigPanel("ins 0,wrap 2", "[][]", "[][]");
        this.extendLayout(p);
        this.addMessageComponent(p);
        this.textField.setText(this.message);
        this.extendLayout(p);
        final JProgressBar bar = new JProgressBar(0, 100);
        p.add((Component)bar, "growx,pushx" + (this.isLabelEnabled() ? "" : ",spanx"));
        bar.setStringPainted(true);
        if (this.isLabelEnabled()) {
            this.lbl = new JLabel();
            this.lbl.setHorizontalAlignment(4);
            p.add((Component)this.lbl, "wmin 30");
        }
        this.updater = new Timer(50, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ProgressDialog.this.getter != null) {
                    int prg = ProgressDialog.this.updateProgress(bar, ProgressDialog.this.getter);
                    ProgressDialog.this.updateText(bar, ProgressDialog.this.getter);
                    ProgressDialog.this.updateLabel();
                    if (prg >= 100) {
                        ProgressDialog.this.updater.stop();
                        ProgressDialog.this.dispose();
                        return;
                    }
                }
            }
        });
        this.updater.setRepeats(true);
        this.updater.setInitialDelay(50);
        this.updater.start();
        this.executer = new InterruptibleThread("ProgressDialogExecuter"){

            @Override
            public void run() {
                try {
                    ProgressDialog.this.getter.run();
                }
                catch (Throwable e) {
                    try {
                        ProgressDialog.this.throwable = e;
                        e.printStackTrace();
                        ProgressDialog.this.setReturnmask(false);
                    }
                    catch (Throwable throwable) {
                        new EDTHelper<Object>(){

                            @Override
                            public Object edtRun() {
                                ProgressDialog.this.dispose();
                                return null;
                            }
                        }.start();
                        ProgressDialog.this.updater.stop();
                        throw throwable;
                    }
                    new /* invalid duplicate definition of identical inner class */.start();
                    ProgressDialog.this.updater.stop();
                }
                new /* invalid duplicate definition of identical inner class */.start();
                ProgressDialog.this.updater.stop();
            }
        };
        this.executer.start();
        return p;
    }

    protected void extendLayout(JPanel p) {
    }

    protected boolean isLabelEnabled() {
        return false;
    }

    public void setWaitForTermination(long waitForTermination) {
        this.waitForTermination = waitForTermination;
    }

    protected void updateText(JProgressBar bar, ProgressGetter getter) {
        String text = getter.getString();
        if (text == null) {
            bar.setStringPainted(false);
        } else {
            bar.setStringPainted(true);
            bar.setString(text);
        }
    }

    protected int updateProgress(JProgressBar bar, ProgressGetter getter) {
        int prg = getter.getProgress();
        if (prg < 0) {
            bar.setIndeterminate(true);
        } else {
            bar.setIndeterminate(false);
            bar.setValue(prg);
        }
        return prg;
    }

    protected void updateLabel() {
        if (this.lbl != null) {
            this.lbl.setText(this.getter.getLabelString());
        }
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public int getProgress() {
        if (this.getter == this) {
            return -1;
        }
        return this.getter.getProgress();
    }

    public static interface ProgressGetter {
        public int getProgress();

        public String getString();

        public void run() throws Exception;

        public String getLabelString();
    }
}

