/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.swing.dialog;

import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.JTextPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.appwork.swing.MigPanel;
import org.appwork.uio.SliderDialogInterface;
import org.appwork.utils.swing.dialog.AbstractDialog;

public class SliderDialog
extends AbstractDialog<Integer>
implements SliderDialogInterface,
ChangeListener {
    private JSlider slider;
    private final String message;
    private JTextPane textpane;
    private final int defaultAnswer;
    protected JLabel statusLabel;

    @Override
    public boolean isRemoteAPIEnabled() {
        return false;
    }

    public SliderDialog(int flag, String title, String question, int defaultValue, Icon icon, String okText, String cancelText) {
        super(flag, title, icon, okText, cancelText);
        this.getLogger().fine("Dialog    [" + okText + "][" + cancelText + "]\r\nflag:  " + Integer.toBinaryString(flag) + "\r\ntitle: " + title + "\r\nmsg:   \r\n" + question + "\r\ndef:" + defaultValue);
        this.message = question;
        this.defaultAnswer = defaultValue;
    }

    protected JSlider createSliderComponent() {
        JSlider slider = new JSlider(0, this.getMinValue(), this.getMaxValue(), this.defaultAnswer);
        slider.setMinorTickSpacing(2);
        slider.setMajorTickSpacing(10);
        slider.setPaintTicks(true);
        slider.setPaintLabels(true);
        slider.setLabelTable(slider.createStandardLabels(10));
        return slider;
    }

    public int getMaxValue() {
        return 100;
    }

    public int getMinValue() {
        return 0;
    }

    public int getValue() {
        return this.slider.getValue();
    }

    @Override
    public JComponent layoutDialogContent() {
        MigPanel contentpane = new MigPanel("ins 0,wrap 1", "[fill,grow]", "[][]");
        this.textpane = new JTextPane();
        this.textpane.setBorder(null);
        this.textpane.setBackground(null);
        this.textpane.setOpaque(false);
        this.textpane.setForeground(new JLabel().getForeground());
        this.textpane.putClientProperty("Synthetica.opaque", Boolean.FALSE);
        this.textpane.setText(this.message);
        this.textpane.setEditable(false);
        contentpane.add(this.textpane);
        this.slider = this.createSliderComponent();
        this.slider.addChangeListener(this);
        contentpane.add((Component)this.slider, "");
        this.statusLabel = new JLabel();
        contentpane.add((Component)this.statusLabel, "");
        this.onSliderValueChanged();
        return contentpane;
    }

    @Override
    protected int getPreferredWidth() {
        return 600;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.onSliderValueChanged();
    }

    protected void onSliderValueChanged() {
    }

    @Override
    protected Integer createReturnValue() {
        return this.getValue();
    }
}

