/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.swing.dimensor;

import java.awt.Dimension;
import java.awt.Window;
import org.appwork.utils.swing.dimensor.DimensorInterface;
import org.appwork.utils.swing.locator.AbstractLocator;

public abstract class AbstractDimensor
implements DimensorInterface {
    protected String id;

    public AbstractDimensor(String id) {
        this.id = id;
    }

    protected Dimension validate(Dimension dimension, Window window) {
        Dimension minimum;
        if (dimension != null && window != null && (minimum = window.getMinimumSize()) != null) {
            if (dimension.height <= minimum.height && dimension.width <= minimum.width) {
                return null;
            }
            Dimension ret = new Dimension(Math.max(dimension.width, minimum.width), Math.max(dimension.height, minimum.height));
            return ret;
        }
        return dimension;
    }

    protected String getStorageID(Window window) {
        return this.getClass().getName().replaceAll("(^.*\\.|[\\d\\$]+$)", "") + "-" + this.getID(window);
    }

    protected String getID(Window window) {
        if (this.id == null) {
            this.id = AbstractLocator.getAutoWindowID(window);
        }
        return this.id;
    }
}

