/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.swing.windowmanager;

import java.awt.AWTException;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Timer;
import org.appwork.utils.Application;
import org.appwork.utils.IO;
import org.appwork.utils.StringUtils;
import org.appwork.utils.swing.windowmanager.ResetRunnable;
import org.appwork.utils.swing.windowmanager.WindowManager;
import org.appwork.utils.swing.windowmanager.WindowResetListener;

public class WindowsWindowManager
extends WindowManager {
    private final AtomicReference<Robot> robot = new AtomicReference<Object>(null);
    private volatile String blocker;
    protected HashMap<Window, ResetRunnable> runnerMap = new HashMap();
    private int foregroundLock = -1;
    private volatile boolean altWorkaroundEnabled = false;
    private volatile int[] altWorkaroundKeys = new int[]{17, 18, 16};

    public boolean isAltWorkaroundEnabled() {
        return this.altWorkaroundEnabled;
    }

    public void setAltWorkaroundEnabled(boolean altWorkaroundEnabled) {
        this.altWorkaroundEnabled = altWorkaroundEnabled;
    }

    public int[] getAltWorkaroundKeys() {
        return this.altWorkaroundKeys;
    }

    public void setAltWorkaroundKeys(int[] altWorkaroundKeys) {
        this.altWorkaroundKeys = altWorkaroundKeys;
    }

    public String getBlocker() {
        return this.blocker;
    }

    public static void writeForegroundLockTimeout(int foregroundLockTimeout) {
        try {
            Process p = Runtime.getRuntime().exec("reg add \"HKEY_CURRENT_USER\\Control Panel\\Desktop\" /v \"ForegroundLockTimeout\" /t REG_DWORD /d 0x" + Integer.toHexString(foregroundLockTimeout) + " /f");
            IO.readInputStreamToString(p.getInputStream());
            int exitCode = p.exitValue();
            if (exitCode != 0) {
                throw new IOException("Reg add execution failed");
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public WindowsWindowManager() {
        this.initForegroundLock();
    }

    protected void initForegroundLock() {
        try {
            this.foregroundLock = WindowsWindowManager.readForegroundLockTimeout();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static int readForegroundLockTimeout() throws UnsupportedEncodingException, IOException {
        String iconResult = IO.readInputStreamToString(Runtime.getRuntime().exec("reg query \"HKEY_CURRENT_USER\\Control Panel\\Desktop\" /v \"ForegroundLockTimeout\"").getInputStream());
        Matcher matcher = Pattern.compile("ForegroundLockTimeout\\s+REG_DWORD\\s+0x(.*)").matcher(iconResult);
        matcher.find();
        String value = matcher.group(1);
        return Integer.parseInt(value, 16);
    }

    @Override
    public void setZState(Window w, WindowManager.FrameState state) {
        switch (state) {
            case OS_DEFAULT: {
                return;
            }
            case TO_FRONT_FOCUSED: {
                if (w.hasFocus()) {
                    return;
                }
                WindowResetListener hasListener = this.findListener(w);
                ResetRunnable runner = this.runnerMap.get(w);
                if (runner == null) {
                    runner = new ResetRunnable(this, w, hasListener);
                    this.runnerMap.put(w, runner);
                    this.executeAfterASecond(runner);
                }
                runner.setState(state);
                this.setFocusableWindowState(w, true);
                this.setFocusable(w, true);
                this.toFrontAltWorkaround(w, true);
                this.requestFocus(w);
                break;
            }
            case TO_BACK: {
                this.setAlwaysOnTop(w, false);
                this.toBack(w);
                break;
            }
            default: {
                WindowResetListener hasListener = this.findListener(w);
                ResetRunnable runner = this.runnerMap.get(w);
                if (runner == null) {
                    runner = new ResetRunnable(this, w, hasListener);
                    this.runnerMap.put(w, runner);
                    this.executeAfterASecond(runner);
                }
                runner.setState(state);
                this.setFocusableWindowState(w, false);
                this.setAlwaysOnTop(w, true);
                this.toFrontAltWorkaround(w, false);
            }
        }
    }

    protected void executeAfterASecond(ActionListener actionListener) {
        Timer timer = new Timer(1000, actionListener);
        timer.setRepeats(false);
        timer.restart();
    }

    protected void toFrontAltWorkaround(Window w, boolean requestFocus) {
        block6: {
            try {
                if (requestFocus && this.foregroundLock > 0 && this.isAltWorkaroundEnabled()) {
                    try {
                        this.pressAlt();
                        this.toFront(w);
                        this.repaint(w);
                        break block6;
                    }
                    finally {
                        this.releaseAlt();
                    }
                }
                this.toFront(w);
                this.repaint(w);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.toFront(w);
                this.repaint(w);
            }
        }
    }

    private void releaseAlt() {
        Robot robot;
        if (this.isAltWorkaroundEnabled() && (robot = (Robot)this.robot.getAndSet(null)) != null) {
            for (int key : this.getAltWorkaroundKeys()) {
                robot.keyRelease(key);
            }
        }
    }

    private void pressAlt() throws AWTException {
        if (this.isAltWorkaroundEnabled()) {
            Robot robot = this.robot.get();
            if (robot == null) {
                robot = new Robot();
                this.robot.getAndSet(robot);
            }
            for (int key : this.getAltWorkaroundKeys()) {
                robot.keyPress(key);
            }
        }
    }

    protected void repaint(Window w) {
    }

    protected void toFront(Window w) {
        w.toFront();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean setAlwaysOnTop(Window w, boolean b) {
        boolean ret = w.isAlwaysOnTop();
        if (b == ret) {
            return ret;
        }
        this.blocker = "alwaysOnTop";
        try {
            w.setAlwaysOnTop(b);
        }
        finally {
            this.blocker = null;
        }
        return ret;
    }

    @Override
    public void setVisible(Window w, boolean visible, WindowManager.FrameState state) {
        if (visible) {
            this.getMetaInfo(w).setShown(System.currentTimeMillis());
        }
        w.removeWindowFocusListener(this.windowFocusListener);
        w.addWindowFocusListener(this.windowFocusListener);
        if (w.isVisible() && visible) {
            this.setZState(w, state);
            return;
        }
        this.addDebugListener(w);
        if (visible) {
            if (state == WindowManager.FrameState.OS_DEFAULT) {
                this.setVisibleInternal(w, visible);
                return;
            }
            this.assignWindowOpenListener(w, state);
            switch (state) {
                case TO_FRONT_FOCUSED: {
                    this.setFocusableWindowState(w, true);
                    break;
                }
                default: {
                    this.setFocusableWindowState(w, false);
                    this.setFocusable(w, false);
                    this.putOffscreen(w, state);
                }
            }
            this.setVisibleInternal(w, visible);
        } else {
            this.setVisibleInternal(w, false);
        }
    }

    protected void putOffscreen(Window w, WindowManager.FrameState state) {
        if (state != WindowManager.FrameState.TO_FRONT) {
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice[] screens = ge.getScreenDevices();
            Point p = new Point(Integer.MIN_VALUE, Integer.MIN_VALUE);
            for (GraphicsDevice screen : screens) {
                Rectangle bounds = screen.getDefaultConfiguration().getBounds();
                p.x = Math.max(bounds.x + bounds.width, p.x);
                p.y = Math.max(bounds.y + bounds.height, p.y);
            }
            ++p.x;
            ++p.y;
            this.setLocation(w, p);
        }
    }

    private Point setLocation(Window w, Point offscreen) {
        this.blocker = "location";
        try {
            w.setLocation(offscreen);
        }
        finally {
            this.blocker = null;
        }
        try {
            return w.getLocationOnScreen();
        }
        catch (IllegalComponentStateException e) {
            return w.getLocation();
        }
    }

    protected void setExtendedState(Frame w, int frameExtendedState) {
        this.blocker = "extendedState";
        try {
            if (frameExtendedState == w.getExtendedState()) {
                return;
            }
            w.setExtendedState(frameExtendedState);
        }
        finally {
            this.blocker = null;
        }
    }

    public WindowResetListener assignWindowOpenListener(Window w, WindowManager.FrameState state) {
        WindowResetListener hasListener = this.findListener(w);
        if (hasListener != null) {
            hasListener.setState(state);
        } else {
            hasListener = new WindowResetListener(this, w, state);
            hasListener.add();
        }
        return hasListener;
    }

    protected WindowResetListener findListener(Window w) {
        WindowResetListener hasListener = null;
        for (WindowListener wl : w.getWindowListeners()) {
            if (wl == null || !(wl instanceof WindowResetListener)) continue;
            hasListener = (WindowResetListener)wl;
            break;
        }
        return hasListener;
    }

    protected void addDebugListener(Window w) {
        if (!Application.isJared(WindowsWindowManager.class)) {
            // empty if block
        }
    }

    protected void log(WindowEvent windowevent) {
    }

    private String name(Component window) {
        if (window == null) {
            return null;
        }
        String ret = window.getName();
        if (StringUtils.isEmpty(ret)) {
            ret = window.getClass().getName();
        }
        return ret;
    }

    private String type(int id) {
        switch (id) {
            case 200: {
                return "WINDOW_OPENED";
            }
            case 201: {
                return "WINDOW_CLOSING";
            }
            case 202: {
                return "WINDOW_CLOSED";
            }
            case 203: {
                return "WINDOW_ICONIFIED";
            }
            case 204: {
                return "WINDOW_DEICONIFIED";
            }
            case 205: {
                return "WINDOW_ACTIVATED";
            }
            case 206: {
                return "WINDOW_DEACTIVATED";
            }
            case 207: {
                return "WINDOW_GAINED_FOCUS";
            }
            case 208: {
                return "WINDOW_LOST_FOCUS";
            }
            case 209: {
                return "WINDOW_STATE_CHANGED";
            }
        }
        return "unknown type";
    }

    protected void setFocusable(Window w, boolean b) {
        if (w.isFocusable() == b) {
            return;
        }
        this.blocker = "focusable";
        try {
            w.setFocusable(b);
        }
        finally {
            this.blocker = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean setFocusableWindowState(Window w, boolean b) {
        boolean ret = w.getFocusableWindowState();
        if (ret == b) {
            return ret;
        }
        this.blocker = "focusableWindowState";
        try {
            w.setFocusableWindowState(b);
        }
        finally {
            this.blocker = null;
        }
        return ret;
    }

    protected void toBack(Window w) {
        w.toBack();
    }

    private void setVisibleInternal(Window w, boolean b) {
        this.blocker = "visible";
        try {
            w.setVisible(b);
        }
        finally {
            this.blocker = null;
        }
    }

    protected void requestFocus(Window w) {
        if (w.getFocusOwner() != null || w.isFocusOwner() || w.isFocused()) {
            return;
        }
        w.requestFocus();
    }

    public void removeTimer(ResetRunnable resetRunnable) {
        this.runnerMap.remove(resetRunnable.getWindow());
    }
}

