/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.zip.tests;

import java.io.File;
import java.io.FileFilter;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.appwork.testframework.AWTest;
import org.appwork.utils.ClassPathScanner;
import org.appwork.utils.ConcatIterator;
import org.appwork.utils.Files;

public abstract class OnClassPathZipJarTests
extends AWTest {
    protected List<File> getZipJarFilesFromClassPath() throws URISyntaxException {
        ArrayList<File> ret = new ArrayList<File>();
        for (URL url : new ConcatIterator(ClassPathScanner.getClassPath(), ClassPathScanner.getBootClassPath())) {
            final File file = new File(url.toURI());
            if (file.isDirectory()) {
                List<File> foundZips = Files.getFiles(new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        return file.isFile() && file.getName().matches("^.+(?i)\\.(jar|zip)$");
                    }
                }, file);
                if (foundZips == null) continue;
                ret.addAll(foundZips);
                continue;
            }
            if (!file.isFile() || !file.getName().matches("^.+(?i)\\.(jar|zip)$")) continue;
            ret.add(file);
        }
        return ret;
    }
}

