/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.update;

import java.awt.Window;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.nio.channels.ClosedByInterruptException;
import java.rmi.ServerException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import org.appwork.updatesys.client.DiskSpaceException;
import org.appwork.updatesys.client.InstallException;
import org.appwork.updatesys.client.LastChanceException;
import org.appwork.updatesys.client.ServerLockedException;
import org.appwork.updatesys.client.UpdateClient;
import org.appwork.updatesys.client.defaultimpl.http.NoConnectionException;
import org.appwork.updatesys.client.lastchance.LastChance;
import org.appwork.updatesys.transport.UpdateServerOfflineException;
import org.appwork.updatesys.transport.exchange.DiskSpaceChanges;
import org.appwork.utils.Application;
import org.appwork.utils.ExtIOException;
import org.appwork.utils.IO;
import org.appwork.utils.StringUtils;
import org.appwork.utils.formatter.SizeFormatter;
import org.appwork.utils.logging2.LogSource;
import org.appwork.utils.logging2.extmanager.LoggerFactory;
import org.appwork.utils.net.httpconnection.HTTPProxy;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.processes.ProcessBuilderFactory;
import org.appwork.utils.swing.dialog.DialogCanceledException;
import org.appwork.utils.swing.dialog.DialogClosedException;
import org.appwork.utils.swing.dialog.DialogNoAnswerException;
import org.appwork.utils.swing.locator.RememberAbsoluteLocator;
import org.jdownloader.update.DialogHook;
import org.jdownloader.update.SelfUpdateException;
import org.jdownloader.update.UpdateManager;
import org.jdownloader.update.locale.T;
import org.jdownloader.updatev2.ForcedRestartRequest;
import org.jdownloader.updatev2.InstallLog;
import org.jdownloader.updatev2.RestartController;
import org.jdownloader.updatev2.UpdateCallbackInterface;
import org.jdownloader.updatev2.UpdateSettings;

public class DefaultCallbackHandler
implements UpdateCallbackInterface {
    private HashSet<Thread> confirmedThreads = new HashSet();
    private boolean doNotAsk;
    private LogSource logger;
    private boolean running;
    private UpdateSettings settings;
    private UpdateManager updateManager;

    public DefaultCallbackHandler(UpdateManager updateManager) {
        this.logger = updateManager.getLogger();
        this.updateManager = updateManager;
        this.settings = updateManager.getSettings();
    }

    private void confirm(String title, String msg, String yes, String no) throws DialogClosedException, DialogCanceledException {
        if (this.confirmedThreads.contains(Thread.currentThread())) {
            return;
        }
        if (!this.isDoNotAsk()) {
            DialogHook.showConfirmDialog(0, title, msg, null, yes, no);
        }
        this.confirmedThreads.add(Thread.currentThread());
    }

    @Override
    public boolean doContinueLoopStarted() {
        return true;
    }

    @Override
    public boolean doContinuePackageAvailable(boolean app, boolean updater, long appDownloadSize, long updaterDownloadSize, int appRevision, int updaterRevision, int appDestRevision, int updaterDestRevision) {
        return true;
    }

    @Override
    public boolean doContinueReadyForExtracting(boolean app, boolean updater, File fileClient, File fileSelf) {
        return true;
    }

    @Override
    public boolean doContinueUpdateAvailable(boolean app, boolean updater, long appDownloadSize, long updaterDownloadSize, int appRevision, int updaterRevision, int appDestRevision, int updaterDestRevision) {
        if (this.settings == null || !this.settings.isDoAskBeforeDownloadingAnUpdate()) {
            this.updateManager.setGuiVisible(true, true);
            return true;
        }
        if (this.isDoNotAsk()) {
            this.updateManager.setGuiVisible(true, true);
            return true;
        }
        try {
            this.confirm(T.T.confirmdialog_new_update_available_frametitle(), T.T.confirmdialog_new_update_available_message(), T.T.confirmdialog_new_update_available_answer_now(), T.T.confirmdialog_new_update_available_answer_later());
            this.updateManager.setGuiVisible(true, true);
            return true;
        }
        catch (DialogClosedException e) {
            LoggerFactory.getDefaultLogger().log(e);
        }
        catch (DialogCanceledException e) {
            LoggerFactory.getDefaultLogger().log(e);
        }
        return false;
    }

    @Override
    public RememberAbsoluteLocator getGuiLocator() {
        return null;
    }

    public LogSource getLogger() {
        return this.logger;
    }

    public static String diskspaceExceptionToString(DiskSpaceException diskSpaceException) {
        StringBuilder error = new StringBuilder();
        UpdateClient client = diskSpaceException.getUpdateClient();
        if (diskSpaceException.getMap() != null) {
            for (Map.Entry<File, DiskSpaceChanges> entry : diskSpaceException.getMap().entrySet()) {
                long free = 0L;
                try {
                    free = client.getFileSystem().getUsableSpace(entry.getKey());
                }
                catch (ExtIOException ioE) {
                    client.getLogger().log(ioE);
                }
                if (free < 0L) continue;
                error.append("\r\n");
                error.append(T.T.errordialog_not_enough_space_specify_incl_changed(entry.getKey(), SizeFormatter.formatBytes(entry.getValue().getRequired()), SizeFormatter.formatBytes(entry.getValue().getRequired() - free), SizeFormatter.formatBytes(Math.max(free, entry.getValue().getRequired()) - entry.getValue().getChanged())).trim());
            }
        } else {
            long free = 0L;
            try {
                free = client.getFileSystem().getUsableSpace(diskSpaceException.getFile());
            }
            catch (ExtIOException ioE) {
                client.getLogger().log(ioE);
            }
            if (free >= 0L) {
                error.append("\r\n");
                error.append(T.T.errordialog_not_enough_space_specify(diskSpaceException.getFile(), SizeFormatter.formatBytes(diskSpaceException.getRequiredBytes()), SizeFormatter.formatBytes(diskSpaceException.getRequiredBytes() - free)));
            }
        }
        return error.toString().trim();
    }

    @Override
    public boolean handleException(Exception e1) {
        block28: {
            try {
                throw e1;
            }
            catch (DiskSpaceException e) {
                this.getLogger().log(e);
                this.updateManager.setGuiVisible(false, true);
                DialogHook.showErrorDialog(16, T.T.errordialog_frametitle(), DefaultCallbackHandler.diskspaceExceptionToString(e));
            }
            catch (LastChanceException e) {
                this.getLogger().log(e);
                new Thread(){

                    @Override
                    public void run() {
                        if (!DefaultCallbackHandler.this.handleLastChanceException(e)) {
                            DialogHook.showExceptionDialog(2064, "Update Failed", "Un unexpected Error occured. Please contact our Support!", e);
                        }
                    }
                }.start();
                this.updateManager.setGuiVisible(false, true);
            }
            catch (SelfUpdateException e) {
                this.getLogger().log(e);
                DialogHook.showExceptionDialog(2064, T.T.errordialog_frametitle(), T.T.errordialog_selfupdate_failed(), e);
                this.updateManager.setGuiVisible(false, true);
                this.updateManager.lastChance(e);
            }
            catch (NoConnectionException e) {
                this.getLogger().log(e);
                if (this.updateManager.isGuiVisible()) {
                    this.updateManager.setGuiVisible(false, true);
                    DialogHook.showErrorDialog(16, T.T.errordialog_frametitle(), T.T.errordialog_noconnection());
                }
            }
            catch (ServerException e) {
                this.getLogger().log(e);
                if (this.updateManager.isGuiVisible()) {
                    this.updateManager.setGuiVisible(false, true);
                    DialogHook.showErrorDialog(16, T.T.errordialog_frametitle(), T.T.errordialog_server_error());
                }
            }
            catch (UpdateServerOfflineException e) {
                this.getLogger().log(e);
                if (this.updateManager.isGuiVisible()) {
                    this.updateManager.setGuiVisible(false, true);
                    DialogHook.showErrorDialog(16, T.T.errordialog_frametitle(), T.T.errordialog_server_offline());
                }
            }
            catch (InterruptedException e) {
                this.getLogger().log(e);
                this.updateManager.setGuiVisible(false, true);
            }
            catch (ClosedByInterruptException e) {
                this.getLogger().log(e);
                this.updateManager.setGuiVisible(false, true);
            }
            catch (ServerLockedException e) {
                boolean guivisible = this.updateManager.isGuiVisible();
                this.updateManager.setGuiVisible(false, true);
                if (guivisible) {
                    DialogHook.showMessageDialog(T.T.errordialog_server_locked2());
                }
            }
            catch (InstallException e) {
                for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
                    if (cause == null) continue;
                    try {
                        throw cause;
                    }
                    catch (DialogNoAnswerException e2) {
                        this.getLogger().log(e);
                        return true;
                    }
                    catch (FileNotFoundException e2) {
                        this.getLogger().log(e);
                        if (!this.updateManager.isGuiVisible()) continue;
                        this.updateManager.setGuiVisible(false, true);
                        DialogHook.showExceptionDialog(2064, T.T.errordialog_frametitle(), T.T.errordialog_cannot_write(e2.getLocalizedMessage()), e2);
                        return true;
                    }
                    catch (InterruptedException e2) {
                        this.getLogger().log(e2);
                        return true;
                    }
                    catch (ExtIOException e2) {
                        if (!this.updateManager.isGuiVisible()) continue;
                        this.updateManager.setGuiVisible(false, true);
                        String path = e2.getStreamInfo();
                        String desc = e2.getDescription();
                        if (StringUtils.isNotEmpty(path) && desc != null && !desc.contains(path)) {
                            DialogHook.showExceptionDialog(2064, T.T.errordialog_frametitle(), T.T.errordialog_cannot_write(path + "(" + desc + ")"), e2);
                        } else {
                            DialogHook.showExceptionDialog(2064, T.T.errordialog_frametitle(), T.T.errordialog_cannot_write2(), e2);
                        }
                        return true;
                    }
                    catch (IOException e2) {
                        this.getLogger().log(e);
                        if (!this.updateManager.isGuiVisible()) continue;
                        this.updateManager.setGuiVisible(false, true);
                        DialogHook.showExceptionDialog(2064, T.T.errordialog_frametitle(), T.T.errordialog_defaultio(), e2);
                        return true;
                    }
                    catch (Exception e2) {
                        continue;
                    }
                    catch (Throwable e2) {
                        // empty catch block
                    }
                }
                this.getLogger().log(e);
                boolean guivisible = this.updateManager.isGuiVisible();
                this.updateManager.setGuiVisible(false, true);
                if (guivisible) {
                    DialogHook.showExceptionDialog(2064, T.T.errordialog_frametitle(), T.T.errordialog_message(), e);
                }
                return true;
            }
            catch (Exception e) {
                this.getLogger().log(e);
                boolean guivisible = this.updateManager.isGuiVisible();
                this.updateManager.setGuiVisible(false, true);
                if (!guivisible) break block28;
                DialogHook.showExceptionDialog(2064, T.T.errordialog_frametitle(), T.T.errordialog_message(), e);
            }
        }
        return true;
    }

    public File getTempFile(String prefix, String suffix) throws IOException {
        return Application.getTempFile(prefix, suffix);
    }

    public boolean handleLastChanceException(LastChanceException lastChanceException) {
        try {
            return LastChance.DefaultLastChanceHandleException(lastChanceException, this.getTempFile("lastChanceSrc", "lch"), this.getTempFile("lastChanceDst", ".jar"));
        }
        catch (Throwable e) {
            lastChanceException.getUpdateClient().getLogger().log(e);
            return false;
        }
    }

    public boolean isDoNotAsk() {
        return this.doNotAsk;
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    @Override
    public void onGuiVisibilityChanged(Window window, boolean oldValue, boolean newValue) {
    }

    @Override
    public void onResults(boolean app, boolean updater, int clientRevision, int clientDestRevision, int selfRevision, int selfDestRevision, File clientAWF, File selfAWF, File selfWOrkingDir, boolean jdLaunched) throws Exception {
        this.logger.info("OnResult");
        boolean threadIsConfirmed = this.confirmedThreads.contains(Thread.currentThread());
        this.logger.info("Confirmed: " + threadIsConfirmed);
        try {
            if (this.updateManager.hasPendingSelfupdate()) {
                this.logger.info("Selfupdate");
                if (this.settings.isDoAskMeBeforeInstallingAnUpdateEnabled()) {
                    this.confirm(T.T.confirmdialog_new_update_available_frametitle(), T.T.confirmdialog_new_update_available_for_install_message_launcher(), T.T.confirmdialog_new_update_available_answer_now_install(), T.T.confirmdialog_new_update_available_answer_later());
                }
                this.updateManager.runFinishSelfUpdate();
                return;
            }
            InstallLog awfoverview = this.updateManager.createAWFInstallLog();
            if (awfoverview.getSourcePackages().size() == 0) {
                Thread.sleep(1000L);
                this.logger.info("empty");
                this.updateManager.setGuiFinished(null);
                return;
            }
            if (awfoverview.getModifiedFiles().size() == 0) {
                this.logger.info("empty package");
                this.updateManager.installPendingAWFFiles();
                return;
            }
            if (awfoverview.getModifiedRestartRequiredFiles().size() == 0 && (this.settings.isInstallUpdatesSilentlyIfPossibleEnabled() || threadIsConfirmed)) {
                this.logger.info("direct Install");
                this.updateManager.installPendingAWFFiles();
                return;
            }
            if (this.settings.isDoAskMeBeforeInstallingAnUpdateEnabled()) {
                this.logger.info("Confirm");
                this.confirm(T.T.confirmdialog_new_update_available_frametitle(), T.T.confirmdialog_new_update_available_for_install_message_launcher(), T.T.confirmdialog_new_update_available_answer_now_install(), T.T.confirmdialog_new_update_available_answer_later());
            }
            if (!jdLaunched) {
                this.logger.info("JD Not launched: install");
                this.updateManager.installPendingAWFFiles();
            } else {
                this.logger.info("restart");
                try {
                    RestartController.getInstance().directRestart(new ForcedRestartRequest("-update"));
                    this.logger.info("DONE");
                }
                catch (Throwable e) {
                    this.logger.log(e);
                }
            }
        }
        catch (DialogClosedException e) {
            this.logger.log(e);
        }
        catch (DialogCanceledException e) {
            this.logger.log(e);
        }
        this.updateManager.setGuiVisible(false, false);
    }

    @Override
    public Process runExeAsynch(List<String> callOrg, File root) throws IOException {
        ArrayList<String> call = new ArrayList<String>(callOrg);
        if (UpdateManager.DEBUG_SELFTEST) {
            call.addAll(RestartController.getInstance().getFilteredRestartParameters(new String[0]));
            this.logger.info("Call: " + call + " in " + root);
            if (CrossSystem.isWindows()) {
                StringBuilder sb = new StringBuilder();
                sb.append("@echo SelfTest for Windows").append("\r\n");
                long time = System.currentTimeMillis();
                sb.append("@echo The Selftest will start now and write all outputs in this window and to " + new File(root, "self_log_err/std" + time + ".txt")).append("\r\n");
                for (String c : call) {
                    if (sb.length() > 0) {
                        sb.append(" ");
                    }
                    sb.append("\"").append(c).append("\"");
                }
                File tmp = Application.getTempResource("selftestLaunch.bat");
                tmp.delete();
                sb.append(" >self_log_std" + time + ".txt  2>self_log_err" + time + ".txt\r\ntype self_log_std" + time + ".txt\r\ntype self_log_err" + time + ".txt");
                sb.append("\r\n");
                sb.append("@echo Please close this window now.");
                IO.writeStringToFile(tmp, sb.toString());
                ArrayList<String> newList = new ArrayList<String>();
                newList.add("cmd");
                newList.add("/C");
                newList.add("start");
                newList.add("/wait");
                newList.add(tmp.getAbsolutePath());
                call = newList;
            }
            ProcessBuilder pb = ProcessBuilderFactory.create(call);
            pb.redirectErrorStream(true);
            pb.directory(root);
            Process process = pb.start();
            if (process != null) {
                this.logger.logAsynch(process.getInputStream());
            }
            return process;
        }
        call.addAll(RestartController.getInstance().getFilteredRestartParameters(new String[0]));
        this.logger.info("Call: " + call + " in " + root);
        ProcessBuilder pb = ProcessBuilderFactory.create(call);
        pb.directory(root);
        Process process = pb.start();
        if (process != null) {
            this.logger.logAsynch(process.getErrorStream());
            this.logger.logAsynch(process.getInputStream());
        }
        return process;
    }

    public void setDoNotAsk(boolean b) {
        this.doNotAsk = b;
    }

    @Override
    public void setRunning(boolean b) {
        this.running = b;
    }

    public void setThreadConfirmed(Thread currentThread, boolean b) {
        if (b) {
            this.confirmedThreads.add(currentThread);
        } else {
            this.confirmedThreads.remove(currentThread);
        }
    }

    @Override
    public void updateGuiIcon(ImageIcon icon) {
    }

    @Override
    public void updateGuiProgress(double progress) {
        System.out.println("Update Progress: " + progress + " %");
    }

    @Override
    public void updateGuiText(String icon) {
    }

    @Override
    public HTTPProxy updateProxyAuth(int retries, HTTPProxy usedProxy, List<String> proxyAuths, URL url) {
        throw new IllegalStateException("Should not happen");
    }

    @Override
    public List<HTTPProxy> selectProxy(URL url) {
        throw new IllegalStateException("Should not happen");
    }

    @Override
    public void append(StringBuilder sb) {
    }
}

