/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.update;

import java.awt.Window;
import java.text.NumberFormat;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.ImageIcon;
import org.jdownloader.update.UIInterface;
import org.jdownloader.update.UpdateManager;
import org.jdownloader.update.gui.PollCallback;

public class HeadlessUpdateGuiWrapper
implements UIInterface {
    private final NumberFormat df;
    private final AtomicReference<Thread> currentPollerThread = new AtomicReference<Object>(null);
    private final UpdateManager updateManager;

    public HeadlessUpdateGuiWrapper(UpdateManager updateManager) {
        this.df = NumberFormat.getInstance();
        this.updateManager = updateManager;
    }

    public UpdateManager getUpdateManager() {
        return this.updateManager;
    }

    @Override
    public void setIcon(ImageIcon icon) {
    }

    @Override
    public void setText(String text) {
        System.out.println("Update Message: " + text);
    }

    @Override
    public void setProgress(double d) {
        System.out.println("Update Progress: " + this.df.format(d) + "%");
    }

    @Override
    public void onHead() {
        System.out.println("JDownloader is Up2Date");
    }

    @Override
    public synchronized void startPoll(final PollCallback pollCallback) {
        this.stopPoll();
        Thread poller = new Thread("Update Poller"){

            @Override
            public void run() {
                try {
                    while (HeadlessUpdateGuiWrapper.this.currentPollerThread.get() == this) {
                        try {
                            pollCallback.run();
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                            break;
                        }
                    }
                }
                finally {
                    HeadlessUpdateGuiWrapper.this.currentPollerThread.compareAndSet(this, null);
                }
            }
        };
        poller.setDaemon(true);
        this.currentPollerThread.set(poller);
        poller.start();
    }

    @Override
    public synchronized void stopPoll() {
        Thread poller = this.currentPollerThread.getAndSet(null);
        if (poller != null) {
            poller.interrupt();
        }
    }

    @Override
    public boolean isVisible() {
        return false;
    }

    @Override
    public void setVisible(boolean b) {
    }

    @Override
    public void setCancelText(String label) {
    }

    @Override
    public void toFront() {
    }

    @Override
    public void setExtendedState(int normal) {
    }

    @Override
    public Window getWindow() {
        throw new IllegalStateException("Cannot access window in headless mode");
    }

    @Override
    public void setAlwaysOnTop(boolean top) {
    }
}

