/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.updatev2;

import java.util.List;
import org.appwork.shutdown.ShutdownRequest;
import org.appwork.shutdown.ShutdownVetoException;
import org.appwork.shutdown.ShutdownVetoListener;
import org.appwork.storage.config.JsonConfig;
import org.appwork.uio.ConfirmDialogInterface;
import org.appwork.uio.UIOManager;
import org.appwork.utils.swing.dialog.ConfirmDialog;
import org.appwork.utils.swing.dialog.DialogNoAnswerException;
import org.jdownloader.updatev2.NoRestartException;
import org.jdownloader.updatev2.RestartRequest;
import org.jdownloader.updatev2.UpdateSettings;
import org.jdownloader.updatev2._UPDATE;

public class InstallUpdatesOnExitRestartRequest
implements RestartRequest {
    protected final ShutdownRequest shutdownRequest;
    private volatile boolean runUpdates = true;

    public InstallUpdatesOnExitRestartRequest(ShutdownRequest filter) {
        this.shutdownRequest = filter;
    }

    @Override
    public boolean askForVeto(ShutdownVetoListener listener) {
        boolean ret = this.shutdownRequest.askForVeto(listener);
        return ret;
    }

    @Override
    public void addVeto(ShutdownVetoException e) {
        this.shutdownRequest.addVeto(e);
    }

    @Override
    public boolean isSilent() {
        return this.shutdownRequest.isSilent();
    }

    @Override
    public List<ShutdownVetoException> getVetos() {
        return this.shutdownRequest.getVetos();
    }

    @Override
    public boolean hasVetos() {
        return this.shutdownRequest.hasVetos();
    }

    @Override
    public void onShutdown() {
        this.runUpdates = true;
        if (JsonConfig.create(UpdateSettings.class).isDoAskMeBeforeInstallingAnUpdateEnabled()) {
            ConfirmDialog dialog = new ConfirmDialog(4, _UPDATE.T.confirmdialog_new_update_available_frametitle(), _UPDATE.T.confirmdialog_new_update_available_for_install_message_launcher(), null, _UPDATE.T.confirmdialog_new_update_available_answer_now_install(), _UPDATE.T.confirmdialog_new_update_available_answer_later_install());
            try {
                ((ConfirmDialogInterface)UIOManager.I().show(ConfirmDialogInterface.class, dialog)).throwCloseExceptions();
            }
            catch (DialogNoAnswerException e) {
                this.runUpdates = false;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public String[] getArguments() throws NoRestartException {
        if (!this.runUpdates) {
            throw new NoRestartException();
        }
        return new String[]{"-updateOnExit"};
    }

    @Override
    public void onShutdownVeto() {
    }

    @Override
    public Integer getExitCode() {
        return null;
    }
}

