// Modal/Bottom Sheet functionality
window.showSheet = function() {
  const sheet = document.getElementById('sheet');
  if (!sheet) return;

  const container = sheet.querySelector('div:last-child');
  sheet.classList.remove('hidden');
  // Force reflow then animate
  sheet.offsetHeight;
  container.classList.remove('translate-y-full');
}

window.hideSheet = function() {
  const sheet = document.getElementById('sheet');
  if (!sheet) return;

  const container = sheet.querySelector('div:last-child');
  container.classList.add('translate-y-full');
  setTimeout(() => {
    sheet.classList.add('hidden');
    const modalContent = document.getElementById('modal-content');
    if (modalContent) {
      modalContent.innerHTML = '';
    }
  }, 300);
}

// Auto-setup event listeners when DOM loads
document.addEventListener('DOMContentLoaded', function() {
  // Show sheet when turbo-frame loads content
  document.addEventListener('turbo:frame-load', function(event) {
    if (event.target.id === 'modal-content' && event.target.innerHTML.trim() !== '') {
      showSheet();
    }
  });

  // Hide sheet on successful form submission
  document.addEventListener('turbo:submit-end', function(event) {
    if (event.detail.success) {
      hideSheet();
    }
  });
});