class Transaction < ApplicationRecord
  belongs_to :customer

  enum :transaction_type, { purchase: 0, visit: 1 }

  validates :amount, presence: true, numericality: { greater_than: 0 }
  validates :transaction_type, presence: true

  scope :purchases, -> { where(transaction_type: :purchase) }
  scope :visits, -> { where(transaction_type: :visit) }
  scope :recent, -> { order(created_at: :desc) }
end
