ActiveRecord::Schema[8.0].define(version: 0) do
  create_table "users", force: :cascade do |t|
    t.string "email_address", null: false
    t.string "password_digest", null: false
    t.datetime "created_at", null: false
    t.datetime "updated_at", null: false
    t.index ["email_address"], name: "index_users_on_email_address", unique: true
  end

  create_table "sessions", force: :cascade do |t|
    t.integer "user_id", null: false
    t.string "ip_address"
    t.string "user_agent"
    t.datetime "created_at", null: false
    t.datetime "updated_at", null: false
    t.index ["user_id"], name: "index_sessions_on_user_id"
  end

  create_table "customers", force: :cascade do |t|
    t.string "name"
    t.string "email"
    t.integer "visits_left", default: 0
    t.datetime "expires_at", precision: 6
    t.datetime "created_at", null: false, precision: 6
    t.datetime "updated_at", null: false, precision: 6
    t.index ["email"], name: "index_customers_on_email", unique: true
  end

  create_table "transactions", force: :cascade do |t|
    t.bigint "customer_id", null: false
    t.integer "transaction_type"
    t.integer "amount"
    t.text "notes"
    t.datetime "created_at", null: false, precision: 6
    t.datetime "updated_at", null: false, precision: 6
    t.index ["customer_id"], name: "index_transactions_on_customer_id"
  end

  add_foreign_key "sessions", "users"
  add_foreign_key "transactions", "customers"
end
