class TenantGuardMiddleware
  def initialize(app)
    @app = app
  end

  def call(env)
    host = env["HTTP_HOST"] || env["SERVER_NAME"] || "localhost"
    subdomain = host.split(".").first

    # Check if this is a non-tenant request
    if subdomain == "localhost" || subdomain.match(/^127/) || subdomain.match(/^\d+$/)
      # Return a simple response without hitting Rails
      available_tenants = [ "widgets", "acme", "testcorp" ]
      tenant_urls = available_tenants.map { |tenant| "http://#{tenant}.lvh.me:3000" }

      response_body = <<~TEXT
        🏢 Zehnerkarten Multi-Tenant System

        No tenant selected. Please access via subdomain:

        #{tenant_urls.join("\n")}

        Each tenant has isolated users, customers, and transactions.
      TEXT

      [ 200, { "Content-Type" => "text/plain" }, [ response_body ] ]
    else
      # Let the request continue to Shardine and Rails
      @app.call(env)
    end
  end
end

