class Customer < ApplicationRecord
  has_many :transactions, dependent: :destroy

  validates :name, presence: true
  validates :email, uniqueness: true, allow_blank: true
  validates :visits_left, numericality: { greater_than_or_equal_to: 0 }

  def purchase_visits(amount, notes = nil)
    transaction = transactions.create!(
      transaction_type: :purchase,
      amount: amount,
      notes: notes
    )
    increment!(:visits_left, amount)
    transaction
  end

  def use_visit(notes = nil)
    return false if visits_left <= 0

    transaction = transactions.create!(
      transaction_type: :visit,
      amount: 1,
      notes: notes
    )
    decrement!(:visits_left)
    transaction
  end
end
