require_relative "boot"

require "rails/all"
require_relative '../lib/shardine.rb'

# Require the gems listed in Gemfile, including any gems
# you've limited to :test, :development, or :production.
Bundler.require(*Rails.groups)

module Zehnerkarten
  class Application < Rails::Application
    # Initialize configuration defaults for originally generated Rails version.
    config.load_defaults 8.0

    # Please, add to the `ignore` list any other `lib` subdirectories that do
    # not contain `.rb` files, or that should not be reloaded or eager loaded.
    # Common ones are `templates`, `generators`, or `middleware`, for example.
    config.autoload_lib(ignore: %w[assets tasks])

    # Add the shardine middleware - always switch to tenant database based on subdomain
    config.middleware.use Shardine::Middleware do |env|
      host = env['HTTP_HOST'] || env['SERVER_NAME'] || 'localhost'
      subdomain = host.split('.').first

      Rails.logger.debug "Shardine: host=#{host}, subdomain=#{subdomain}"

      # Only switch to tenant database if we have a valid subdomain
      if subdomain && subdomain != 'localhost' && !subdomain.match(/^127/) && !subdomain.match(/^\d+$/)
        Rails.logger.debug "Shardine: switching to tenant database for #{subdomain}"
        {
          adapter: "sqlite3",
          database: Rails.root.join("db", "tenant_#{subdomain}_#{Rails.env}.sqlite3")
        }
      else
        # For non-subdomain access, return nil to skip database switching
        # This will cause the request to fail with database errors, which we'll handle
        Rails.logger.debug "Shardine: non-subdomain access, no tenant database switching"
        nil
      end
    end

    # Configuration for the application, engines, and railties goes here.
    #
    # These settings can be overridden in specific environments using the files
    # in config/environments, which are processed later.
    #
    # config.time_zone = "Central Time (US & Canada)"
    # config.eager_load_paths << Rails.root.join("extras")
  end
end
